/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.AbstractAccessParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FootAccessParser
extends AbstractAccessParser
implements TagParser {
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Set<String> allowedHighwayTags = new HashSet<String>();
    final Set<String> avoidHighwayTags = new HashSet<String>();
    final Set<String> allowedSacScale = new HashSet<String>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "foot"))));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected FootAccessParser(BooleanEncodedValue accessEnc) {
        super(accessEnc, TransportationMode.FOOT);
        this.intendedValues.add("yes");
        this.intendedValues.add("designated");
        this.intendedValues.add("official");
        this.intendedValues.add("permissive");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.barriers.add("fence");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.avoidHighwayTags.add("tertiary");
        this.avoidHighwayTags.add("tertiary_link");
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
        this.allowedSacScale.add("hiking");
        this.allowedSacScale.add("mountain_hiking");
        this.allowedSacScale.add("demanding_mountain_hiking");
    }

    public WayAccess getAccess(ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            String footTag;
            WayAccess acceptPotentially = WayAccess.CAN_SKIP;
            if (way.hasTag("route", (Collection<String>)this.ferries) && ((footTag = way.getTag("foot")) == null || this.intendedValues.contains(footTag))) {
                acceptPotentially = WayAccess.FERRY;
            }
            if (way.hasTag("railway", (Object)"platform")) {
                acceptPotentially = WayAccess.WAY;
            }
            if (way.hasTag("man_made", (Object)"pier")) {
                acceptPotentially = WayAccess.WAY;
            }
            if (!acceptPotentially.canSkip()) {
                if (way.hasTag(this.restrictions, (Collection<String>)this.restrictedValues) && !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way)) {
                    return WayAccess.CAN_SKIP;
                }
                return acceptPotentially;
            }
            return WayAccess.CAN_SKIP;
        }
        if (way.getTag("sac_scale") != null && !way.hasTag("sac_scale", this.allowedSacScale)) {
            return WayAccess.CAN_SKIP;
        }
        boolean permittedWayConditionallyRestricted = this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way);
        boolean restrictedWayConditionallyPermitted = this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (!firstValue.isEmpty()) {
            String[] restrict;
            for (String value : restrict = firstValue.split(";")) {
                if (this.restrictedValues.contains(value) && !restrictedWayConditionallyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value) || permittedWayConditionallyRestricted) continue;
                return WayAccess.WAY;
            }
        }
        if (way.hasTag("sidewalk", this.sidewalkValues)) {
            return WayAccess.WAY;
        }
        if (!this.allowedHighwayTags.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("motorroad", (Object)"yes")) {
            return WayAccess.CAN_SKIP;
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (permittedWayConditionallyRestricted) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (way.hasTag("oneway:foot", (Collection<String>)this.oneways) || way.hasTag("foot:backward", new String[0]) || way.hasTag("foot:forward", new String[0]) || way.hasTag("oneway", (Collection<String>)this.oneways) && way.hasTag("highway", (Object)"steps")) {
            boolean reverse = way.hasTag("oneway:foot", (Object)"-1") || way.hasTag("foot:backward", (Object)"yes") || way.hasTag("foot:forward", (Object)"no");
            this.accessEnc.setBool(reverse, edgeFlags, true);
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
        Map<String, Object> nodeTags = way.getTag("node_tags", Collections.emptyMap());
        this.handleNodeTags(edgeFlags, nodeTags);
    }
}

