/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FootAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    static final int SLOW_SPEED = 2;
    static final int MEAN_SPEED = 5;
    static final int FERRY_SPEED = 15;
    final Set<String> safeHighwayTags = new HashSet<String>();
    final Set<String> allowedHighwayTags = new HashSet<String>();
    final Set<String> avoidHighwayTags = new HashSet<String>();
    protected HashSet<String> sidewalkValues = new HashSet(5);
    protected HashSet<String> sidewalksNoValues = new HashSet(5);
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "foot"))));
    }

    protected FootAverageSpeedParser(DecimalEncodedValue speedEnc) {
        super(speedEnc, speedEnc.getNextStorableValue(15.0));
        this.sidewalksNoValues.add("no");
        this.sidewalksNoValues.add("none");
        this.sidewalksNoValues.add("separate");
        this.sidewalkValues.add("yes");
        this.sidewalkValues.add("both");
        this.sidewalkValues.add("left");
        this.sidewalkValues.add("right");
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("path");
        this.safeHighwayTags.add("steps");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("track");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.avoidHighwayTags.add("trunk");
        this.avoidHighwayTags.add("trunk_link");
        this.avoidHighwayTags.add("primary");
        this.avoidHighwayTags.add("primary_link");
        this.avoidHighwayTags.add("secondary");
        this.avoidHighwayTags.add("secondary_link");
        this.avoidHighwayTags.add("tertiary");
        this.avoidHighwayTags.add("tertiary_link");
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        String sacScale;
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
                this.setSpeed(edgeFlags, true, true, ferrySpeed);
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        if ((sacScale = way.getTag("sac_scale")) != null) {
            this.setSpeed(edgeFlags, true, true, "hiking".equals(sacScale) ? 5.0 : 2.0);
        } else {
            this.setSpeed(edgeFlags, true, true, way.hasTag("highway", (Object)"steps") ? 3.0 : 5.0);
        }
    }

    void setSpeed(IntsRef edgeFlags, boolean fwd, boolean bwd, double speed) {
        if (speed > this.getMaxSpeed()) {
            speed = this.getMaxSpeed();
        }
        if (fwd) {
            this.avgSpeedEnc.setDecimal(false, edgeFlags, speed);
        }
        if (bwd && this.avgSpeedEnc.isStoreTwoDirections()) {
            this.avgSpeedEnc.setDecimal(true, edgeFlags, speed);
        }
    }
}

