/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.Collection;

public class MotorcycleAccessParser
extends CarAccessParser {
    public MotorcycleAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(VehicleAccess.key(properties.getString("name", "motorcycle"))), lookup.getBooleanEncodedValue("roundabout"), properties, TransportationMode.MOTORCYCLE);
    }

    public MotorcycleAccessParser(BooleanEncodedValue accessEnc, BooleanEncodedValue roundaboutEnc, PMap properties, TransportationMode transportationMode) {
        super(accessEnc, roundaboutEnc, properties, transportationMode);
        this.barriers.remove("bus_trap");
        this.barriers.remove("sump_buster");
        this.trackTypeValues.clear();
        this.trackTypeValues.addAll(Arrays.asList("grade1"));
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        String tt;
        String highwayValue = way.getTag("highway");
        String firstValue = way.getFirstPriorityTag(this.restrictions);
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                if (this.restrictedValues.contains(firstValue)) {
                    return WayAccess.CAN_SKIP;
                }
                if (this.intendedValues.contains(firstValue) || firstValue.isEmpty() && !way.hasTag("foot", new String[0]) && !way.hasTag("bicycle", new String[0])) {
                    return WayAccess.FERRY;
                }
            }
            return WayAccess.CAN_SKIP;
        }
        if ("service".equals(highwayValue) && "emergency_access".equals(way.getTag("service"))) {
            return WayAccess.CAN_SKIP;
        }
        if ("track".equals(highwayValue) && (tt = way.getTag("tracktype")) != null && !tt.equals("grade1")) {
            return WayAccess.CAN_SKIP;
        }
        if (!this.highwayValues.contains(highwayValue)) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("impassable", (Object)"yes") || way.hasTag("status", (Object)"impassable")) {
            return WayAccess.CAN_SKIP;
        }
        if (!firstValue.isEmpty()) {
            String[] restrict = firstValue.split(";");
            boolean notConditionalyPermitted = !this.getConditionalTagInspector().isRestrictedWayConditionallyPermitted(way);
            for (String value : restrict) {
                if (this.restrictedValues.contains(value) && notConditionalyPermitted) {
                    return WayAccess.CAN_SKIP;
                }
                if (!this.intendedValues.contains(value)) continue;
                return WayAccess.WAY;
            }
        }
        if (this.isBlockFords() && ("ford".equals(highwayValue) || way.hasTag("ford", new String[0]))) {
            return WayAccess.CAN_SKIP;
        }
        if (this.getConditionalTagInspector().isPermittedWayConditionallyRestricted(way)) {
            return WayAccess.CAN_SKIP;
        }
        return WayAccess.WAY;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        if (!access.isFerry()) {
            boolean isRoundabout = this.roundaboutEnc.getBool(false, edgeFlags);
            if (way.hasTag("oneway", (Collection<String>)this.oneways) || isRoundabout) {
                if (way.hasTag("oneway", (Object)"-1")) {
                    this.accessEnc.setBool(true, edgeFlags, true);
                } else {
                    this.accessEnc.setBool(false, edgeFlags, true);
                }
            } else {
                this.accessEnc.setBool(true, edgeFlags, true);
                this.accessEnc.setBool(false, edgeFlags, true);
            }
        } else {
            this.accessEnc.setBool(false, edgeFlags, true);
            this.accessEnc.setBool(true, edgeFlags, true);
        }
    }
}

