/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.parsers.CarAverageSpeedParser;
import com.graphhopper.routing.util.parsers.helpers.OSMValueExtractor;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.Collection;

public class MotorcycleAverageSpeedParser
extends CarAverageSpeedParser {
    public static final double MOTORCYCLE_MAX_SPEED = 120.0;

    public MotorcycleAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "motorcycle"))), lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "motorcycle"))).getNextStorableValue(120.0));
    }

    public MotorcycleAverageSpeedParser(DecimalEncodedValue speedEnc, double maxPossibleSpeed) {
        super(speedEnc, maxPossibleSpeed);
        this.defaultSpeedMap.clear();
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("trunk", 80);
        this.defaultSpeedMap.put("trunk_link", 75);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 5);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.trackTypeSpeedMap.clear();
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put(null, this.defaultSpeedMap.get("track"));
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
                this.setSpeed(false, edgeFlags, ferrySpeed);
                this.setSpeed(true, edgeFlags, ferrySpeed);
            }
        } else {
            double speed = this.getSpeed(way);
            this.setSpeed(true, edgeFlags, this.applyMaxSpeed(way, speed, true));
            this.setSpeed(false, edgeFlags, this.applyMaxSpeed(way, speed, true));
        }
    }

    @Override
    protected double applyMaxSpeed(ReaderWay way, double speed, boolean bwd) {
        speed = super.applyMaxSpeed(way, speed, bwd);
        double maxMCSpeed = OSMValueExtractor.stringToKmh(way.getTag("maxspeed:motorcycle"));
        if (MotorcycleAverageSpeedParser.isValidSpeed(maxMCSpeed)) {
            speed = Math.min(maxMCSpeed * 0.9, speed);
        }
        if (MotorcycleAverageSpeedParser.isValidSpeed(speed) && speed > 30.0 && way.hasTag("surface", (Collection<String>)this.badSurfaceSpeedMap)) {
            speed = 30.0;
        }
        return speed;
    }
}

