/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.HashSet;

public class MotorcyclePriorityParser
implements TagParser {
    private final HashSet<String> avoidSet = new HashSet();
    private final HashSet<String> preferSet = new HashSet();
    private final DecimalEncodedValue priorityWayEncoder;

    public MotorcyclePriorityParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "motorcycle"))));
    }

    public MotorcyclePriorityParser(DecimalEncodedValue priorityWayEncoder) {
        this.priorityWayEncoder = priorityWayEncoder;
        this.avoidSet.add("motorway");
        this.avoidSet.add("trunk");
        this.avoidSet.add("residential");
        this.preferSet.add("primary");
        this.preferSet.add("secondary");
        this.preferSet.add("tertiary");
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way)));
    }

    private int handlePriority(ReaderWay way) {
        String highway = way.getTag("highway", "");
        if (this.avoidSet.contains(highway) || way.hasTag("motorroad", (Object)"yes")) {
            return PriorityCode.BAD.getValue();
        }
        if (this.preferSet.contains(highway)) {
            return PriorityCode.BEST.getValue();
        }
        return PriorityCode.UNCHANGED.getValue();
    }
}

