/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMHikeRatingParser
implements TagParser {
    private final IntEncodedValue sacScaleEnc;

    public OSMHikeRatingParser(IntEncodedValue sacScaleEnc) {
        this.sacScaleEnc = sacScaleEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String scale = readerWay.getTag("sac_scale");
        int rating = 0;
        if (scale != null) {
            if (scale.equals("hiking")) {
                rating = 1;
            } else if (scale.equals("mountain_hiking")) {
                rating = 2;
            } else if (scale.equals("demanding_mountain_hiking")) {
                rating = 3;
            } else if (scale.equals("alpine_hiking")) {
                rating = 4;
            } else if (scale.equals("demanding_alpine_hiking")) {
                rating = 5;
            } else if (scale.equals("difficult_alpine_hiking")) {
                rating = 6;
            }
        }
        if (rating != 0) {
            this.sacScaleEnc.setInt(false, edgeFlags, rating);
        }
    }
}

