/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMRoadClassParser
implements TagParser {
    protected final EnumEncodedValue<RoadClass> roadClassEnc;

    public OSMRoadClassParser(EnumEncodedValue<RoadClass> roadClassEnc) {
        this.roadClassEnc = roadClassEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String roadClassTag = readerWay.getTag("highway");
        if (roadClassTag == null) {
            return;
        }
        RoadClass roadClass = RoadClass.find(roadClassTag);
        if (roadClass == RoadClass.OTHER && roadClassTag.endsWith("_link")) {
            roadClass = RoadClass.find(roadClassTag.substring(0, roadClassTag.length() - 5));
        }
        if (roadClass != RoadClass.OTHER) {
            this.roadClassEnc.setEnum(false, edgeFlags, roadClass);
        }
    }
}

