/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMSurfaceParser
implements TagParser {
    private final EnumEncodedValue<Surface> surfaceEnc;

    public OSMSurfaceParser(EnumEncodedValue<Surface> surfaceEnc) {
        this.surfaceEnc = surfaceEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        String surfaceTag = readerWay.getTag("surface");
        Surface surface = Surface.find(surfaceTag);
        if (surface == Surface.MISSING) {
            return;
        }
        if (surfaceTag.equals("metal")) {
            surface = Surface.PAVED;
        } else if (surfaceTag.equals("sett")) {
            surface = Surface.COBBLESTONE;
        } else if (surfaceTag.equals("wood")) {
            surface = Surface.UNPAVED;
        } else if (surfaceTag.equals("earth")) {
            surface = Surface.DIRT;
        }
        this.surfaceEnc.setEnum(false, edgeFlags, surface);
    }
}

