/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.util.countryrules.CountryRule;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OSMTollParser
implements TagParser {
    private static final List<String> HGV_TAGS = Collections.unmodifiableList(Arrays.asList("toll:hgv", "toll:N2", "toll:N3"));
    private final EnumEncodedValue<Toll> tollEnc;

    public OSMTollParser(EnumEncodedValue<Toll> tollEnc) {
        this.tollEnc = tollEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay readerWay, IntsRef relationFlags) {
        Toll toll = readerWay.hasTag("toll", (Object)"yes") ? Toll.ALL : (readerWay.hasTag(HGV_TAGS, Collections.singletonList("yes")) ? Toll.HGV : (readerWay.hasTag("toll", (Object)"no") ? Toll.NO : Toll.MISSING));
        CountryRule countryRule = readerWay.getTag("country_rule", null);
        if (countryRule != null) {
            toll = countryRule.getToll(readerWay, toll);
        }
        this.tollEnc.setEnum(false, edgeFlags, toll);
    }
}

