/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class OSMWayIDParser
implements TagParser {
    private final IntEncodedValue osmWayIdEnc;

    public OSMWayIDParser(IntEncodedValue osmWayIdEnc) {
        this.osmWayIdEnc = osmWayIdEnc;
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        if (way.getId() > (long)this.osmWayIdEnc.getMaxStorableInt()) {
            throw new IllegalArgumentException("Cannot store OSM way ID: " + way.getId() + " as it is too large (> " + this.osmWayIdEnc.getMaxStorableInt() + "). You can disable " + this.osmWayIdEnc.getName() + " if you do not need to store the OSM way IDs");
        }
        int wayId = Math.toIntExact(way.getId());
        this.osmWayIdEnc.setInt(false, edgeFlags, wayId);
    }
}

