/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.reader.osm.GraphRestriction;
import com.graphhopper.reader.osm.Pair;
import com.graphhopper.reader.osm.RestrictionType;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import java.util.List;

public class RestrictionSetter {
    private final BaseGraph baseGraph;
    private final EdgeExplorer edgeExplorer;
    private final IntIntMap artificialEdgesByEdges = new IntIntHashMap();

    public RestrictionSetter(BaseGraph baseGraph) {
        this.baseGraph = baseGraph;
        this.edgeExplorer = baseGraph.createEdgeExplorer();
    }

    public void setRestrictions(List<Pair<GraphRestriction, RestrictionType>> restrictions, DecimalEncodedValue turnCostEnc) {
        this.addArtificialEdges(restrictions);
        this.addViaWayRestrictions(restrictions, turnCostEnc);
        this.addViaNodeRestrictions(restrictions, turnCostEnc);
    }

    private void addArtificialEdges(List<Pair<GraphRestriction, RestrictionType>> restrictions) {
        for (Pair<GraphRestriction, RestrictionType> p : restrictions) {
            int viaEdge;
            int artificialEdge;
            if (!((GraphRestriction)p.first).isViaWayRestriction() || RestrictionSetter.ignoreViaWayRestriction(p) || (artificialEdge = this.artificialEdgesByEdges.getOrDefault(viaEdge = ((GraphRestriction)p.first).getViaEdges().get(0), -1)) >= 0) continue;
            EdgeIteratorState viaEdgeState = this.baseGraph.getEdgeIteratorState(((GraphRestriction)p.first).getViaEdges().get(0), Integer.MIN_VALUE);
            EdgeIteratorState artificialEdgeState = this.baseGraph.edge(viaEdgeState.getBaseNode(), viaEdgeState.getAdjNode()).setFlags(viaEdgeState.getFlags()).setWayGeometry(viaEdgeState.fetchWayGeometry(FetchMode.PILLAR_ONLY)).setDistance(viaEdgeState.getDistance()).setKeyValues(viaEdgeState.getKeyValues());
            artificialEdge = artificialEdgeState.getEdge();
            this.artificialEdgesByEdges.put(viaEdge, artificialEdge);
        }
    }

    private void addViaWayRestrictions(List<Pair<GraphRestriction, RestrictionType>> restrictions, DecimalEncodedValue turnCostEnc) {
        IntHashSet viaEdgesUsedByOnlyRestrictions = new IntHashSet();
        for (Pair<GraphRestriction, RestrictionType> p : restrictions) {
            if (!((GraphRestriction)p.first).isViaWayRestriction() || RestrictionSetter.ignoreViaWayRestriction(p)) continue;
            int fromEdge = ((GraphRestriction)p.first).getFromEdges().get(0);
            int viaEdge = ((GraphRestriction)p.first).getViaEdges().get(0);
            int toEdge = ((GraphRestriction)p.first).getToEdges().get(0);
            int artificialVia = this.artificialEdgesByEdges.getOrDefault(viaEdge, viaEdge);
            if (artificialVia == viaEdge) {
                throw new IllegalArgumentException("There should be an artificial edge for every via edge of a way restriction");
            }
            if (p.second == RestrictionType.ONLY && !viaEdgesUsedByOnlyRestrictions.add(viaEdge)) {
                throw new IllegalStateException("We cannot deal with 'only' via-way restrictions that use the same via edges");
            }
            int artificialFrom = this.artificialEdgesByEdges.getOrDefault(fromEdge, fromEdge);
            int artificialTo = this.artificialEdgesByEdges.getOrDefault(toEdge, toEdge);
            int fromToViaNode = ((GraphRestriction)p.first).getViaNodes().get(0);
            int viaToToNode = ((GraphRestriction)p.first).getViaNodes().get(1);
            this.restrictTurn(turnCostEnc, artificialVia, fromToViaNode, viaEdge);
            this.restrictTurn(turnCostEnc, viaEdge, fromToViaNode, artificialVia);
            this.restrictTurn(turnCostEnc, artificialVia, viaToToNode, viaEdge);
            this.restrictTurn(turnCostEnc, viaEdge, viaToToNode, artificialVia);
            if (p.second == RestrictionType.NO) {
                this.restrictTurn(turnCostEnc, fromEdge, fromToViaNode, viaEdge);
                this.restrictTurn(turnCostEnc, artificialVia, viaToToNode, toEdge);
            } else if (p.second == RestrictionType.ONLY) {
                EdgeIterator iter = this.edgeExplorer.setBaseNode(fromToViaNode);
                while (iter.next()) {
                    if (iter.getEdge() == fromEdge || iter.getEdge() == artificialVia) continue;
                    this.restrictTurn(turnCostEnc, fromEdge, fromToViaNode, iter.getEdge());
                }
                iter = this.edgeExplorer.setBaseNode(viaToToNode);
                while (iter.next()) {
                    if (iter.getEdge() == artificialVia || iter.getEdge() == toEdge) continue;
                    this.restrictTurn(turnCostEnc, artificialVia, viaToToNode, iter.getEdge());
                }
            } else {
                throw new IllegalArgumentException("Unexpected restriction type: " + p.second);
            }
            if (artificialFrom != fromEdge) {
                this.restrictTurn(turnCostEnc, artificialFrom, fromToViaNode, artificialVia);
            }
            if (artificialTo == toEdge) continue;
            this.restrictTurn(turnCostEnc, artificialVia, viaToToNode, artificialTo);
        }
    }

    private void addViaNodeRestrictions(List<Pair<GraphRestriction, RestrictionType>> restrictions, DecimalEncodedValue turnCostEnc) {
        for (Pair<GraphRestriction, RestrictionType> p : restrictions) {
            if (((GraphRestriction)p.first).isViaWayRestriction()) continue;
            int viaNode = ((GraphRestriction)p.first).getViaNodes().get(0);
            for (IntCursor fromEdgeCursor : ((GraphRestriction)p.first).getFromEdges()) {
                for (IntCursor toEdgeCursor : ((GraphRestriction)p.first).getToEdges()) {
                    int fromEdge = fromEdgeCursor.value;
                    int toEdge = toEdgeCursor.value;
                    int artificialFrom = this.artificialEdgesByEdges.getOrDefault(fromEdge, fromEdge);
                    int artificialTo = this.artificialEdgesByEdges.getOrDefault(toEdge, toEdge);
                    if (p.second == RestrictionType.NO) {
                        this.restrictTurn(turnCostEnc, fromEdge, viaNode, toEdge);
                        if (artificialFrom != fromEdge) {
                            this.restrictTurn(turnCostEnc, artificialFrom, viaNode, toEdge);
                        }
                        if (artificialTo != toEdge) {
                            this.restrictTurn(turnCostEnc, fromEdge, viaNode, artificialTo);
                        }
                        if (artificialFrom == fromEdge || artificialTo == toEdge) continue;
                        this.restrictTurn(turnCostEnc, artificialFrom, viaNode, artificialTo);
                        continue;
                    }
                    if (p.second == RestrictionType.ONLY) {
                        EdgeIterator iter = this.edgeExplorer.setBaseNode(viaNode);
                        while (iter.next()) {
                            if (iter.getEdge() != fromEdge && iter.getEdge() != toEdge && iter.getEdge() != artificialTo) {
                                this.restrictTurn(turnCostEnc, fromEdge, viaNode, iter.getEdge());
                            }
                            if (fromEdge == artificialFrom || iter.getEdge() == artificialFrom || iter.getEdge() == toEdge || iter.getEdge() == artificialTo) continue;
                            this.restrictTurn(turnCostEnc, artificialFrom, viaNode, iter.getEdge());
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected restriction type: " + p.second);
                }
            }
        }
    }

    public IntIntMap getArtificialEdgesByEdges() {
        return this.artificialEdgesByEdges;
    }

    private void restrictTurn(DecimalEncodedValue turnCostEnc, int fromEdge, int viaNode, int toEdge) {
        if (fromEdge < 0 || toEdge < 0 || viaNode < 0) {
            throw new IllegalArgumentException("from/toEdge and viaNode must be >= 0");
        }
        this.baseGraph.getTurnCostStorage().set(turnCostEnc, fromEdge, viaNode, toEdge, Double.POSITIVE_INFINITY);
    }

    private static boolean ignoreViaWayRestriction(Pair<GraphRestriction, RestrictionType> p) {
        if (((GraphRestriction)p.first).getViaEdges().size() > 1) {
            return true;
        }
        return ((GraphRestriction)p.first).getFromEdges().size() > 1 || ((GraphRestriction)p.first).getToEdges().size() > 1;
    }
}

