/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import com.graphhopper.util.PointList;
import java.util.Collection;

public class WheelchairAverageSpeedParser
extends FootAverageSpeedParser {
    private final int maxInclinePercent = 6;

    public WheelchairAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(properties.getString("name", VehicleSpeed.key("wheelchair"))));
    }

    protected WheelchairAverageSpeedParser(DecimalEncodedValue speedEnc) {
        super(speedEnc);
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.safeHighwayTags.remove("steps");
        this.safeHighwayTags.remove("track");
        this.allowedHighwayTags.clear();
        this.allowedHighwayTags.addAll(this.safeHighwayTags);
        this.allowedHighwayTags.addAll(this.avoidHighwayTags);
        this.allowedHighwayTags.add("cycleway");
        this.allowedHighwayTags.add("unclassified");
        this.allowedHighwayTags.add("road");
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way) {
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (way.hasTag("route", (Collection<String>)this.ferries)) {
                double ferrySpeed = this.ferrySpeedCalc.getSpeed(way);
                this.setSpeed(edgeFlags, true, true, ferrySpeed);
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        this.setSpeed(edgeFlags, true, true, 5.0);
        this.applyWayTags(way, edgeFlags);
    }

    public void applyWayTags(ReaderWay way, IntsRef edgeFlags) {
        PointList pl = way.getTag("point_list", null);
        if (pl == null) {
            throw new IllegalArgumentException("The artificial point_list tag is missing");
        }
        if (!way.hasTag("edge_distance", new String[0])) {
            throw new IllegalArgumentException("The artificial edge_distance tag is missing");
        }
        double fullDist2D = way.getTag("edge_distance", 0.0);
        if (Double.isInfinite(fullDist2D)) {
            throw new IllegalStateException("Infinite distance should not happen due to #435. way ID=" + way.getId());
        }
        if (fullDist2D < 20.0 || !pl.is3D()) {
            return;
        }
        double prevEle = pl.getEle(0);
        double eleDelta = pl.getEle(pl.size() - 1) - prevEle;
        double elePercent = eleDelta / fullDist2D * 100.0;
        int smallInclinePercent = 3;
        double fwdSpeed = 0.0;
        double bwdSpeed = 0.0;
        if (elePercent > (double)smallInclinePercent && elePercent < 6.0) {
            fwdSpeed = 2.0;
            bwdSpeed = 5.0;
        } else if (elePercent < (double)(-smallInclinePercent) && elePercent > -6.0) {
            fwdSpeed = 5.0;
            bwdSpeed = 2.0;
        } else if (elePercent > 6.0 || elePercent < -6.0) {
            if (fullDist2D > 50.0) {
                this.setSpeed(edgeFlags, true, false, 0.0);
                this.setSpeed(edgeFlags, true, true, 0.0);
                return;
            }
            fwdSpeed = 2.0;
            bwdSpeed = 2.0;
        }
        if (fwdSpeed > 0.0) {
            this.setSpeed(edgeFlags, true, false, fwdSpeed);
        }
        if (bwdSpeed > 0.0) {
            this.setSpeed(edgeFlags, false, true, bwdSpeed);
        }
    }
}

