/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.FootPriorityParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.PMap;
import java.util.TreeMap;

public class WheelchairPriorityParser
extends FootPriorityParser {
    public WheelchairPriorityParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(properties.getString("name", VehiclePriority.key("wheelchair"))), lookup.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class));
    }

    protected WheelchairPriorityParser(DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> footRouteEnc) {
        super(priorityEnc, footRouteEnc);
        this.safeHighwayTags.add("footway");
        this.safeHighwayTags.add("pedestrian");
        this.safeHighwayTags.add("living_street");
        this.safeHighwayTags.add("residential");
        this.safeHighwayTags.add("service");
        this.safeHighwayTags.add("platform");
        this.safeHighwayTags.remove("steps");
        this.safeHighwayTags.remove("track");
    }

    @Override
    public void handleWayTags(IntsRef edgeFlags, ReaderWay way, IntsRef relationFlags) {
        Integer priorityFromRelation = (Integer)this.routeMap.get(this.footRouteEnc.getEnum(false, edgeFlags));
        this.priorityWayEncoder.setDecimal(false, edgeFlags, PriorityCode.getValue(this.handlePriority(way, priorityFromRelation)));
    }

    @Override
    public int handlePriority(ReaderWay way, Integer priorityFromRelation) {
        TreeMap<Double, Integer> weightToPrioMap = new TreeMap<Double, Integer>();
        weightToPrioMap.put(100.0, super.handlePriority(way, priorityFromRelation));
        if (way.hasTag("wheelchair", (Object)"designated")) {
            weightToPrioMap.put(102.0, PriorityCode.VERY_NICE.getValue());
        } else if (way.hasTag("wheelchair", (Object)"limited")) {
            weightToPrioMap.put(102.0, PriorityCode.AVOID.getValue());
        }
        return (Integer)weightToPrioMap.lastEntry().getValue();
    }
}

