/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.shapes.BBox;
import java.util.Locale;

class BaseGraphNodesAndEdges {
    private static final double INT_DIST_FACTOR = 1000.0;
    static double MAX_DIST = 2147483.647;
    private final DataAccess nodes;
    private final int N_EDGE_REF;
    private final int N_LAT;
    private final int N_LON;
    private final int N_ELE;
    private final int N_TC;
    private int nodeEntryBytes;
    private int nodeCount;
    private final DataAccess edges;
    private final int E_NODEA;
    private final int E_NODEB;
    private final int E_LINKA;
    private final int E_LINKB;
    private final int E_FLAGS;
    private final int E_DIST;
    private final int E_GEO;
    private final int E_KV;
    private final int intsForFlags;
    private int edgeEntryBytes;
    private int edgeCount;
    private final boolean withTurnCosts;
    private final boolean withElevation;
    public final BBox bounds;
    private boolean frozen;

    public BaseGraphNodesAndEdges(Directory dir, int intsForFlags, boolean withElevation, boolean withTurnCosts, int segmentSize) {
        this.nodes = dir.create("nodes", dir.getDefaultType("nodes", true), segmentSize);
        this.edges = dir.create("edges", dir.getDefaultType("edges", true), segmentSize);
        this.intsForFlags = intsForFlags;
        this.withTurnCosts = withTurnCosts;
        this.withElevation = withElevation;
        this.bounds = BBox.createInverse(withElevation);
        this.N_EDGE_REF = 0;
        this.N_LAT = 4;
        this.N_LON = 8;
        this.N_ELE = this.N_LON + (withElevation ? 4 : 0);
        this.N_TC = this.N_ELE + (withTurnCosts ? 4 : 0);
        this.nodeEntryBytes = this.N_TC + 4;
        this.E_NODEA = 0;
        this.E_NODEB = 4;
        this.E_LINKA = 8;
        this.E_LINKB = 12;
        this.E_FLAGS = 16;
        this.E_DIST = this.E_FLAGS + intsForFlags * 4;
        this.E_GEO = this.E_DIST + 4;
        this.E_KV = this.E_GEO + 4;
        this.edgeEntryBytes = this.E_KV + 4;
    }

    public void create(long initSize) {
        this.nodes.create(initSize);
        this.edges.create(initSize);
    }

    public boolean loadExisting() {
        boolean hasElevation;
        if (!this.nodes.loadExisting() || !this.edges.loadExisting()) {
            return false;
        }
        int nodesVersion = this.nodes.getHeader(0);
        GHUtility.checkDAVersion("nodes", 9, nodesVersion);
        this.nodeEntryBytes = this.nodes.getHeader(4);
        this.nodeCount = this.nodes.getHeader(8);
        this.bounds.minLon = Helper.intToDegree((int)this.nodes.getHeader(12));
        this.bounds.maxLon = Helper.intToDegree((int)this.nodes.getHeader(16));
        this.bounds.minLat = Helper.intToDegree((int)this.nodes.getHeader(20));
        this.bounds.maxLat = Helper.intToDegree((int)this.nodes.getHeader(24));
        boolean bl = hasElevation = this.nodes.getHeader(28) == 1;
        if (hasElevation != this.withElevation) {
            throw new IllegalStateException("Configured dimension elevation=" + this.withElevation + " is not equal to dimension of loaded graph elevation =" + hasElevation);
        }
        if (this.withElevation) {
            this.bounds.minEle = Helper.intToEle((int)this.nodes.getHeader(32));
            this.bounds.maxEle = Helper.intToEle((int)this.nodes.getHeader(36));
        }
        this.frozen = this.nodes.getHeader(40) == 1;
        int edgesVersion = this.edges.getHeader(0);
        GHUtility.checkDAVersion("edges", 21, edgesVersion);
        this.edgeEntryBytes = this.edges.getHeader(4);
        this.edgeCount = this.edges.getHeader(8);
        return true;
    }

    public void flush() {
        this.nodes.setHeader(0, 9);
        this.nodes.setHeader(4, this.nodeEntryBytes);
        this.nodes.setHeader(8, this.nodeCount);
        this.nodes.setHeader(12, Helper.degreeToInt((double)this.bounds.minLon));
        this.nodes.setHeader(16, Helper.degreeToInt((double)this.bounds.maxLon));
        this.nodes.setHeader(20, Helper.degreeToInt((double)this.bounds.minLat));
        this.nodes.setHeader(24, Helper.degreeToInt((double)this.bounds.maxLat));
        this.nodes.setHeader(28, this.withElevation ? 1 : 0);
        if (this.withElevation) {
            this.nodes.setHeader(32, Helper.eleToInt((double)this.bounds.minEle));
            this.nodes.setHeader(36, Helper.eleToInt((double)this.bounds.maxEle));
        }
        this.nodes.setHeader(40, this.frozen ? 1 : 0);
        this.edges.setHeader(0, 21);
        this.edges.setHeader(4, this.edgeEntryBytes);
        this.edges.setHeader(8, this.edgeCount);
        this.edges.flush();
        this.nodes.flush();
    }

    public void close() {
        this.edges.close();
        this.nodes.close();
    }

    public int getNodes() {
        return this.nodeCount;
    }

    public int getEdges() {
        return this.edgeCount;
    }

    public int getIntsForFlags() {
        return this.intsForFlags;
    }

    public boolean withElevation() {
        return this.withElevation;
    }

    public boolean withTurnCosts() {
        return this.withTurnCosts;
    }

    public BBox getBounds() {
        return this.bounds;
    }

    public long getCapacity() {
        return this.nodes.getCapacity() + this.edges.getCapacity();
    }

    public boolean isClosed() {
        assert (this.nodes.isClosed() == this.edges.isClosed());
        return this.nodes.isClosed();
    }

    public int edge(int nodeA, int nodeB) {
        if (this.edgeCount == Integer.MAX_VALUE) {
            throw new IllegalStateException("Maximum edge count exceeded: " + this.edgeCount);
        }
        this.ensureNodeCapacity(Math.max(nodeA, nodeB));
        int edge = this.edgeCount;
        long edgePointer = (long)this.edgeCount * (long)this.edgeEntryBytes;
        ++this.edgeCount;
        this.edges.ensureCapacity((long)this.edgeCount * (long)this.edgeEntryBytes);
        this.setNodeA(edgePointer, nodeA);
        this.setNodeB(edgePointer, nodeB);
        long nodePointerA = this.toNodePointer(nodeA);
        int edgeRefA = this.getEdgeRef(nodePointerA);
        this.setLinkA(edgePointer, EdgeIterator.Edge.isValid(edgeRefA) ? edgeRefA : -1);
        this.setEdgeRef(nodePointerA, edge);
        if (nodeA != nodeB) {
            long nodePointerB = this.toNodePointer(nodeB);
            int edgeRefB = this.getEdgeRef(nodePointerB);
            this.setLinkB(edgePointer, EdgeIterator.Edge.isValid(edgeRefB) ? edgeRefB : -1);
            this.setEdgeRef(nodePointerB, edge);
        }
        return edge;
    }

    public void ensureNodeCapacity(int node) {
        if (node < this.nodeCount) {
            return;
        }
        int oldNodes = this.nodeCount;
        this.nodeCount = node + 1;
        this.nodes.ensureCapacity((long)this.nodeCount * (long)this.nodeEntryBytes);
        for (int n = oldNodes; n < this.nodeCount; ++n) {
            this.setEdgeRef(this.toNodePointer(n), -1);
            if (!this.withTurnCosts) continue;
            this.setTurnCostRef(this.toNodePointer(n), -1);
        }
    }

    public long toNodePointer(int node) {
        if (node < 0 || node >= this.nodeCount) {
            throw new IllegalArgumentException("node: " + node + " out of bounds [0," + this.nodeCount + "[");
        }
        return (long)node * (long)this.nodeEntryBytes;
    }

    public long toEdgePointer(int edge) {
        if (edge < 0 || edge >= this.edgeCount) {
            throw new IllegalArgumentException("edge: " + edge + " out of bounds [0," + this.edgeCount + "[");
        }
        return (long)edge * (long)this.edgeEntryBytes;
    }

    public void readFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            edgeFlags.ints[i] = this.edges.getInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4));
        }
    }

    public void writeFlags(long edgePointer, IntsRef edgeFlags) {
        int size = edgeFlags.ints.length;
        for (int i = 0; i < size; ++i) {
            this.edges.setInt(edgePointer + (long)this.E_FLAGS + (long)(i * 4), edgeFlags.ints[i]);
        }
    }

    public void setNodeA(long edgePointer, int nodeA) {
        this.edges.setInt(edgePointer + (long)this.E_NODEA, nodeA);
    }

    public void setNodeB(long edgePointer, int nodeB) {
        this.edges.setInt(edgePointer + (long)this.E_NODEB, nodeB);
    }

    public void setLinkA(long edgePointer, int linkA) {
        this.edges.setInt(edgePointer + (long)this.E_LINKA, linkA);
    }

    public void setLinkB(long edgePointer, int linkB) {
        this.edges.setInt(edgePointer + (long)this.E_LINKB, linkB);
    }

    public void setDist(long edgePointer, double distance) {
        this.edges.setInt(edgePointer + (long)this.E_DIST, this.distToInt(distance));
    }

    public void setGeoRef(long edgePointer, int geoRef) {
        this.edges.setInt(edgePointer + (long)this.E_GEO, geoRef);
    }

    public void setKeyValuesRef(long edgePointer, int nameRef) {
        this.edges.setInt(edgePointer + (long)this.E_KV, nameRef);
    }

    public int getNodeA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEA);
    }

    public int getNodeB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_NODEB);
    }

    public int getLinkA(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKA);
    }

    public int getLinkB(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_LINKB);
    }

    public double getDist(long pointer) {
        int val = this.edges.getInt(pointer + (long)this.E_DIST);
        return (double)val / 1000.0;
    }

    public int getGeoRef(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_GEO);
    }

    public int getKeyValuesRef(long edgePointer) {
        return this.edges.getInt(edgePointer + (long)this.E_KV);
    }

    public void setEdgeRef(long nodePointer, int edgeRef) {
        this.nodes.setInt(nodePointer + (long)this.N_EDGE_REF, edgeRef);
    }

    public void setLat(long nodePointer, double lat) {
        this.nodes.setInt(nodePointer + (long)this.N_LAT, Helper.degreeToInt((double)lat));
    }

    public void setLon(long nodePointer, double lon) {
        this.nodes.setInt(nodePointer + (long)this.N_LON, Helper.degreeToInt((double)lon));
    }

    public void setEle(long elePointer, double ele) {
        this.nodes.setInt(elePointer + (long)this.N_ELE, Helper.eleToInt((double)ele));
    }

    public void setTurnCostRef(long nodePointer, int tcRef) {
        this.nodes.setInt(nodePointer + (long)this.N_TC, tcRef);
    }

    public int getEdgeRef(long nodePointer) {
        return this.nodes.getInt(nodePointer + (long)this.N_EDGE_REF);
    }

    public double getLat(long nodePointer) {
        return Helper.intToDegree((int)this.nodes.getInt(nodePointer + (long)this.N_LAT));
    }

    public double getLon(long nodePointer) {
        return Helper.intToDegree((int)this.nodes.getInt(nodePointer + (long)this.N_LON));
    }

    public double getEle(long nodePointer) {
        return Helper.intToEle((int)this.nodes.getInt(nodePointer + (long)this.N_ELE));
    }

    public int getTurnCostRef(long nodePointer) {
        return this.nodes.getInt(nodePointer + (long)this.N_TC);
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean getFrozen() {
        return this.frozen;
    }

    public void debugPrint() {
        int printMax = 100;
        System.out.println("nodes:");
        String formatNodes = "%12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatNodes, "#", "N_EDGE_REF", "N_LAT", "N_LON");
        for (int i = 0; i < Math.min(this.nodeCount, 100); ++i) {
            long nodePointer = this.toNodePointer(i);
            System.out.format(Locale.ROOT, formatNodes, i, this.getEdgeRef(nodePointer), this.getLat(nodePointer), this.getLon(nodePointer));
        }
        if (this.nodeCount > 100) {
            System.out.format(Locale.ROOT, " ... %d more nodes\n", this.nodeCount - 100);
        }
        System.out.println("edges:");
        String formatEdges = "%12s | %12s | %12s | %12s | %12s | %12s | %12s \n";
        System.out.format(Locale.ROOT, formatEdges, "#", "E_NODEA", "E_NODEB", "E_LINKA", "E_LINKB", "E_FLAGS", "E_DIST");
        IntsRef intsRef = new IntsRef(this.intsForFlags);
        for (int i = 0; i < Math.min(this.edgeCount, 100); ++i) {
            long edgePointer = this.toEdgePointer(i);
            this.readFlags(edgePointer, intsRef);
            System.out.format(Locale.ROOT, formatEdges, i, this.getNodeA(edgePointer), this.getNodeB(edgePointer), this.getLinkA(edgePointer), this.getLinkB(edgePointer), intsRef, this.getDist(edgePointer));
        }
        if (this.edgeCount > 100) {
            System.out.printf(Locale.ROOT, " ... %d more edges", this.edgeCount - 100);
        }
    }

    private int distToInt(double distance) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("Distance cannot be negative: " + distance);
        }
        if (distance > MAX_DIST) {
            distance = MAX_DIST;
        }
        int intDist = (int)Math.round(distance * 1000.0);
        assert (intDist >= 0) : "distance out of range";
        return intDist;
    }

    public String toDetailsString() {
        return "edges: " + Helper.nf((long)this.edgeCount) + "(" + this.edges.getCapacity() / 0x100000L + "MB), nodes: " + Helper.nf((long)this.nodeCount) + "(" + this.nodes.getCapacity() / 0x100000L + "MB), bounds: " + this.bounds;
    }
}

