/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import com.graphhopper.util.shapes.GHPoint3D;

public class Snap {
    public static final int INVALID_NODE = -1;
    private final GHPoint queryPoint;
    private double queryDistance = Double.MAX_VALUE;
    private int wayIndex = -1;
    private int closestNode = -1;
    private EdgeIteratorState closestEdge;
    private GHPoint3D snappedPoint;
    private Position snappedPosition;

    public Snap(double queryLat, double queryLon) {
        this.queryPoint = new GHPoint(queryLat, queryLon);
    }

    public int getClosestNode() {
        return this.closestNode;
    }

    public void setClosestNode(int node) {
        this.closestNode = node;
    }

    public double getQueryDistance() {
        return this.queryDistance;
    }

    public void setQueryDistance(double dist) {
        this.queryDistance = dist;
    }

    public int getWayIndex() {
        return this.wayIndex;
    }

    public void setWayIndex(int wayIndex) {
        this.wayIndex = wayIndex;
    }

    public Position getSnappedPosition() {
        return this.snappedPosition;
    }

    public void setSnappedPosition(Position pos) {
        this.snappedPosition = pos;
    }

    public boolean isValid() {
        return this.closestNode >= 0;
    }

    public EdgeIteratorState getClosestEdge() {
        return this.closestEdge;
    }

    public void setClosestEdge(EdgeIteratorState edge) {
        this.closestEdge = edge;
    }

    public GHPoint getQueryPoint() {
        return this.queryPoint;
    }

    public GHPoint3D getSnappedPoint() {
        if (this.snappedPoint == null) {
            throw new IllegalStateException("Calculate snapped point before!");
        }
        return this.snappedPoint;
    }

    public void setSnappedPoint(GHPoint3D point) {
        this.snappedPoint = point;
    }

    public void calcSnappedPoint(DistanceCalc distCalc) {
        double adjLon;
        if (this.closestEdge == null) {
            throw new IllegalStateException("No closest edge?");
        }
        if (this.snappedPoint != null) {
            throw new IllegalStateException("Calculate snapped point only once");
        }
        PointList fullPL = this.getClosestEdge().fetchWayGeometry(FetchMode.ALL);
        double tmpLat = fullPL.getLat(this.wayIndex);
        double tmpLon = fullPL.getLon(this.wayIndex);
        double tmpEle = fullPL.getEle(this.wayIndex);
        if (this.snappedPosition != Position.EDGE) {
            this.snappedPoint = new GHPoint3D(tmpLat, tmpLon, tmpEle);
            return;
        }
        double queryLat = this.getQueryPoint().lat;
        double queryLon = this.getQueryPoint().lon;
        double adjLat = fullPL.getLat(this.wayIndex + 1);
        if (distCalc.validEdgeDistance(queryLat, queryLon, tmpLat, tmpLon, adjLat, adjLon = fullPL.getLon(this.wayIndex + 1))) {
            GHPoint crossingPoint = distCalc.calcCrossingPointToEdge(queryLat, queryLon, tmpLat, tmpLon, adjLat, adjLon);
            double adjEle = fullPL.getEle(this.wayIndex + 1);
            if (Snap.considerEqual(crossingPoint.lat, crossingPoint.lon, tmpLat, tmpLon)) {
                this.snappedPosition = this.wayIndex == 0 ? Position.TOWER : Position.PILLAR;
                this.snappedPoint = new GHPoint3D(tmpLat, tmpLon, tmpEle);
            } else if (Snap.considerEqual(crossingPoint.lat, crossingPoint.lon, adjLat, adjLon)) {
                ++this.wayIndex;
                this.snappedPosition = this.wayIndex == fullPL.size() - 1 ? Position.TOWER : Position.PILLAR;
                this.snappedPoint = new GHPoint3D(adjLat, adjLon, adjEle);
            } else {
                this.snappedPoint = new GHPoint3D(crossingPoint.lat, crossingPoint.lon, (tmpEle + adjEle) / 2.0);
            }
        } else assert (false) : "incorrect pos: " + (Object)((Object)this.snappedPosition) + " for " + this.snappedPoint + ", " + fullPL + ", " + this.wayIndex;
    }

    public static boolean considerEqual(double lat, double lon, double lat2, double lon2) {
        return Math.abs(lat - lat2) < 1.0E-6 && Math.abs(lon - lon2) < 1.0E-6;
    }

    public String toString() {
        if (this.closestEdge != null) {
            return (Object)((Object)this.snappedPosition) + ", " + this.closestNode + " " + this.closestEdge.getEdge() + ":" + this.closestEdge.getBaseNode() + "-" + this.closestEdge.getAdjNode() + " snap: [" + Helper.round6((double)this.snappedPoint.getLat()) + ", " + Helper.round6((double)this.snappedPoint.getLon()) + "], query: [" + Helper.round6((double)this.queryPoint.getLat()) + "," + Helper.round6((double)this.queryPoint.getLon()) + "]";
        }
        return this.closestNode + ", " + this.queryPoint + ", " + this.wayIndex;
    }

    public static enum Position {
        EDGE,
        TOWER,
        PILLAR;

    }
}

