/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.details.PathDetailsBuilder;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PathDetailsFromEdges
implements Path.EdgeVisitor {
    private final List<PathDetailsBuilder> calculators;
    private int lastIndex = 0;

    public PathDetailsFromEdges(List<PathDetailsBuilder> calculators, int previousIndex) {
        this.calculators = calculators;
        this.lastIndex = previousIndex;
    }

    public static Map<String, List<PathDetail>> calcDetails(Path path, EncodedValueLookup evLookup, Weighting weighting, List<String> requestedPathDetails, PathDetailsBuilderFactory pathBuilderFactory, int previousIndex, Graph graph) {
        if (!path.isFound() || requestedPathDetails.isEmpty()) {
            return Collections.emptyMap();
        }
        List<PathDetailsBuilder> pathBuilders = pathBuilderFactory.createPathDetailsBuilders(requestedPathDetails, evLookup, weighting, graph);
        if (pathBuilders.isEmpty()) {
            return Collections.emptyMap();
        }
        path.forEveryEdge(new PathDetailsFromEdges(pathBuilders, previousIndex));
        HashMap<String, List<PathDetail>> pathDetails = new HashMap<String, List<PathDetail>>(pathBuilders.size());
        for (PathDetailsBuilder builder : pathBuilders) {
            Map.Entry<String, List<PathDetail>> entry = builder.build();
            List<PathDetail> existing = pathDetails.put(entry.getKey(), entry.getValue());
            if (existing == null) continue;
            throw new IllegalStateException("Some PathDetailsBuilders use duplicate key: " + entry.getKey());
        }
        return pathDetails;
    }

    @Override
    public void next(EdgeIteratorState edge, int index, int prevEdgeId) {
        for (PathDetailsBuilder calc : this.calculators) {
            if (!calc.isEdgeDifferentToLastEdge(edge)) continue;
            calc.endInterval(this.lastIndex);
            calc.startInterval(this.lastIndex);
        }
        this.lastIndex += edge.fetchWayGeometry(FetchMode.PILLAR_AND_ADJ).size();
    }

    @Override
    public void finish() {
        for (PathDetailsBuilder calc : this.calculators) {
            calc.endInterval(this.lastIndex);
        }
    }
}

