/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.carrotsearch.hppc.IntDoubleHashMap;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;

public class EdgeElevationSmoothingMovingAverage {
    public static void smooth(PointList geometry, double maxWindowSize) {
        if (geometry.size() <= 2) {
            return;
        }
        double[] distances = new double[geometry.size() - 1];
        for (int i = 0; i <= geometry.size() - 2; ++i) {
            distances[i] = DistancePlaneProjection.DIST_PLANE.calcDist(geometry.getLat(i), geometry.getLon(i), geometry.getLat(i + 1), geometry.getLon(i + 1));
        }
        IntDoubleHashMap averagedElevations = new IntDoubleHashMap((geometry.size() - 1) * 4 / 3);
        for (int i = 1; i <= geometry.size() - 2; ++i) {
            double searchDistance = maxWindowSize / 2.0;
            double searchDistanceBack = 0.0;
            for (int j = i - 1; j >= 0 && !((searchDistanceBack += distances[j]) > searchDistance); --j) {
            }
            searchDistance = Math.min(searchDistance, searchDistanceBack);
            double searchDistanceForward = 0.0;
            for (int j = i; j < geometry.size() - 1 && !((searchDistanceForward += distances[j]) > searchDistance); ++j) {
            }
            if ((searchDistance = Math.min(searchDistance, searchDistanceForward)) <= 0.0) continue;
            double elevationArea = 0.0;
            double distanceBack = 0.0;
            for (int j = i - 1; j >= 0; --j) {
                double dist = distances[j];
                double searchDistLeft = searchDistance - distanceBack;
                distanceBack += dist;
                if (searchDistLeft < dist) {
                    double elevationDelta = geometry.getEle(j) - geometry.getEle(j + 1);
                    double elevationAtSearchDistance = geometry.getEle(j + 1) + searchDistLeft / dist * elevationDelta;
                    elevationArea += searchDistLeft * (geometry.getEle(j + 1) + elevationAtSearchDistance) / 2.0;
                    break;
                }
                elevationArea += dist * (geometry.getEle(j + 1) + geometry.getEle(j)) / 2.0;
            }
            double distanceForward = 0.0;
            for (int j = i; j < geometry.size() - 1; ++j) {
                double dist = distances[j];
                double searchDistLeft = searchDistance - distanceForward;
                distanceForward += dist;
                if (searchDistLeft < dist) {
                    double elevationDelta = geometry.getEle(j + 1) - geometry.getEle(j);
                    double elevationAtSearchDistance = geometry.getEle(j) + searchDistLeft / dist * elevationDelta;
                    elevationArea += searchDistLeft * (geometry.getEle(j) + elevationAtSearchDistance) / 2.0;
                    break;
                }
                elevationArea += dist * (geometry.getEle(j + 1) + geometry.getEle(j)) / 2.0;
            }
            double elevationAverage = elevationArea / (searchDistance * 2.0);
            averagedElevations.put(i, elevationAverage);
        }
        averagedElevations.forEach(c -> geometry.setElevation(c.key, c.value));
    }
}

