/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.osm.GraphRestriction;
import com.graphhopper.reader.osm.OSMRestrictionException;
import com.graphhopper.reader.osm.RestrictionMembers;
import com.graphhopper.reader.osm.Triple;
import com.graphhopper.reader.osm.WayToEdgeConverter;
import com.graphhopper.storage.BaseGraph;
import java.util.Iterator;
import java.util.Map;
import java.util.function.LongFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictionConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictionConverter.class);
    private static final long[] EMPTY_LONG_ARRAY_LIST = new long[0];

    public static boolean isTurnRestriction(ReaderRelation relation) {
        return "restriction".equals(relation.getTag("type"));
    }

    public static long[] getRestrictedWayIds(ReaderRelation relation) {
        if (!RestrictionConverter.isTurnRestriction(relation)) {
            return EMPTY_LONG_ARRAY_LIST;
        }
        return relation.getMembers().stream().filter(m -> m.getType() == ReaderElement.Type.WAY).filter(m -> "from".equals(m.getRole()) || "via".equals(m.getRole()) || "to".equals(m.getRole())).mapToLong(ReaderRelation.Member::getRef).toArray();
    }

    public static long getViaNodeIfViaNodeRestriction(ReaderRelation relation) {
        return relation.getMembers().stream().filter(m -> m.getType().equals((Object)ReaderElement.Type.NODE)).filter(m -> "via".equals(m.getRole())).mapToLong(ReaderRelation.Member::getRef).findFirst().orElse(-1L);
    }

    public static Triple<ReaderRelation, GraphRestriction, RestrictionMembers> convert(ReaderRelation relation, BaseGraph baseGraph, LongFunction<Iterator<IntCursor>> edgesByWay) throws OSMRestrictionException {
        if (!RestrictionConverter.isTurnRestriction(relation)) {
            throw new IllegalArgumentException("expected a turn restriction: " + relation.getTags());
        }
        RestrictionMembers restrictionMembers = RestrictionConverter.extractMembers(relation);
        if (!RestrictionConverter.membersExist(restrictionMembers, edgesByWay, relation)) {
            throw OSMRestrictionException.withoutWarning();
        }
        WayToEdgeConverter wayToEdgeConverter = new WayToEdgeConverter(baseGraph, edgesByWay);
        if (restrictionMembers.isViaWay()) {
            WayToEdgeConverter.EdgeResult res = wayToEdgeConverter.convertForViaWays(restrictionMembers.getFromWays(), restrictionMembers.getViaWays(), restrictionMembers.getToWays());
            return new Triple<ReaderRelation, GraphRestriction, RestrictionMembers>(relation, GraphRestriction.way(res.getFromEdges(), res.getViaEdges(), res.getToEdges(), res.getNodes()), restrictionMembers);
        }
        int viaNode = relation.getTag("graphhopper:via_node", -1);
        if (viaNode < 0) {
            throw new IllegalStateException("For some reason we did not set graphhopper:via_node for this relation: " + relation.getId());
        }
        WayToEdgeConverter.NodeResult res = wayToEdgeConverter.convertForViaNode(restrictionMembers.getFromWays(), viaNode, restrictionMembers.getToWays());
        return new Triple<ReaderRelation, GraphRestriction, RestrictionMembers>(relation, GraphRestriction.node(res.getFromEdges(), viaNode, res.getToEdges()), restrictionMembers);
    }

    private static boolean membersExist(RestrictionMembers members, LongFunction<Iterator<IntCursor>> edgesByWay, ReaderRelation relation) {
        for (LongCursor c : members.getAllWays()) {
            if (edgesByWay.apply(c.value).hasNext()) continue;
            LOGGER.debug("Restriction relation " + relation.getId() + " uses excluded way " + c.value + ". Relation ignored.");
            return false;
        }
        return true;
    }

    public static void checkIfCompatibleWithRestriction(GraphRestriction g, String restriction) throws OSMRestrictionException {
        if (g.getFromEdges().size() > 1 && !"no_entry".equals(restriction)) {
            throw new OSMRestrictionException("has multiple members with role 'from' even though it is not a 'no_entry' restriction");
        }
        if (g.getToEdges().size() > 1 && !"no_exit".equals(restriction)) {
            throw new OSMRestrictionException("has multiple members with role 'to' even though it is not a 'no_exit' restriction");
        }
    }

    public static RestrictionMembers extractMembers(ReaderRelation relation) throws OSMRestrictionException {
        long viaOSMNode = -1L;
        LongArrayList fromWays = new LongArrayList();
        LongArrayList viaWays = new LongArrayList();
        LongArrayList toWays = new LongArrayList();
        for (ReaderRelation.Member member : relation.getMembers()) {
            if ("from".equals(member.getRole())) {
                if (member.getType() != ReaderElement.Type.WAY) {
                    throw new OSMRestrictionException("has a member with role 'from' and type '" + (Object)((Object)member.getType()) + "', but it should be of type 'way'");
                }
                fromWays.add(member.getRef());
                continue;
            }
            if ("to".equals(member.getRole())) {
                if (member.getType() != ReaderElement.Type.WAY) {
                    throw new OSMRestrictionException("has a member with role 'to' and type '" + (Object)((Object)member.getType()) + "', but it should be of type 'way'");
                }
                toWays.add(member.getRef());
                continue;
            }
            if ("via".equals(member.getRole())) {
                if (member.getType() == ReaderElement.Type.NODE) {
                    if (viaOSMNode >= 0L) {
                        throw new OSMRestrictionException("has multiple members with role 'via' and type 'node', but multiple via-members are only allowed when they are of type: 'way'");
                    }
                    viaOSMNode = member.getRef();
                    continue;
                }
                if (member.getType() == ReaderElement.Type.WAY) {
                    viaWays.add(member.getRef());
                    continue;
                }
                throw new OSMRestrictionException("has a member with role 'via' and type '" + (Object)((Object)member.getType()) + "', but it should be of type 'node' or 'way'");
            }
            if ("location_hint".equals(member.getRole())) continue;
            if (member.getRole().trim().isEmpty()) {
                throw new OSMRestrictionException("has a member with an empty role");
            }
            throw new OSMRestrictionException("has a member with an unknown role '" + member.getRole() + "'");
        }
        if (fromWays.isEmpty() && toWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'from' and 'to'");
        }
        if (fromWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'from'");
        }
        if (toWays.isEmpty()) {
            throw new OSMRestrictionException("has no member with role 'to'");
        }
        if (fromWays.size() > 1 && toWays.size() > 1) {
            throw new OSMRestrictionException("has multiple members with role 'from' and 'to'");
        }
        RestrictionConverter.checkTags(fromWays, toWays, relation.getTags());
        if (viaOSMNode >= 0L && !viaWays.isEmpty()) {
            throw new OSMRestrictionException("has members with role 'via' of type 'node' and 'way', but only one type is allowed");
        }
        if (viaOSMNode >= 0L) {
            return RestrictionMembers.viaNode(viaOSMNode, fromWays, toWays);
        }
        if (!viaWays.isEmpty()) {
            return RestrictionMembers.viaWay(fromWays, viaWays, toWays);
        }
        throw new OSMRestrictionException("has no member with role 'via'");
    }

    private static void checkTags(LongArrayList fromWays, LongArrayList toWays, Map<String, Object> tags) throws OSMRestrictionException {
        boolean hasNoEntry = false;
        boolean hasNoExit = false;
        for (Map.Entry<String, Object> e : tags.entrySet()) {
            if (!e.getKey().startsWith("restriction")) continue;
            if (e.getValue() != null && ((String)e.getValue()).startsWith("no_entry")) {
                hasNoEntry = true;
            }
            if (e.getValue() == null || !((String)e.getValue()).startsWith("no_exit")) continue;
            hasNoExit = true;
        }
        if (fromWays.size() > 1 && !hasNoEntry) {
            throw new OSMRestrictionException("has multiple members with role 'from' even though it is not a 'no_entry' restriction");
        }
        if (toWays.size() > 1 && !hasNoExit) {
            throw new OSMRestrictionException("has multiple members with role 'to' even though it is not a 'no_exit' restriction");
        }
    }
}

