/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.cursors.LongCursor;
import com.graphhopper.reader.ReaderElement;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.ReaderRelation;
import com.graphhopper.reader.ReaderWay;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.osm.OSMFileHeader;
import com.graphhopper.reader.osm.OSMInput;
import com.graphhopper.reader.osm.OSMInputFile;
import com.graphhopper.reader.osm.OSMNodeData;
import com.graphhopper.reader.osm.SegmentNode;
import com.graphhopper.reader.osm.SkipOptions;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.GHPoint3D;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.LongToIntFunction;
import java.util.function.Predicate;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaySegmentParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaySegmentParser.class);
    private static final Set<String> INCLUDE_IF_NODE_TAGS = new HashSet<String>(Arrays.asList("barrier", "highway", "railway", "crossing", "ford"));
    private ElevationProvider elevationProvider = ElevationProvider.NOOP;
    private Predicate<ReaderWay> wayFilter = way -> true;
    private Predicate<ReaderNode> splitNodeFilter = node -> false;
    private WayPreprocessor wayPreprocessor = (way, supplier) -> {};
    private Consumer<ReaderRelation> relationPreprocessor = relation -> {};
    private RelationProcessor relationProcessor = (relation, map) -> {};
    private EdgeHandler edgeHandler = (from, to, pointList, way, nodeTags) -> System.out.println("edge " + from + "->" + to + " (" + pointList.size() + " points)");
    private int workerThreads = 2;
    private final OSMNodeData nodeData;
    private Date timestamp;

    private WaySegmentParser(OSMNodeData nodeData) {
        this.nodeData = nodeData;
    }

    public void readOSM(File osmFile) {
        if (this.nodeData.getNodeCount() > 0L) {
            throw new IllegalStateException("You can only run way segment parser once");
        }
        LOGGER.info("Start reading OSM file: '" + osmFile + "'");
        LOGGER.info("pass1 - start");
        StopWatch sw1 = StopWatch.started();
        this.readOSM(osmFile, new Pass1Handler(), new SkipOptions(true, false, false));
        LOGGER.info("pass1 - finished, took: {}", (Object)sw1.stop().getTimeString());
        long nodes = this.nodeData.getNodeCount();
        LOGGER.info("Creating graph. Node count (pillar+tower): " + nodes + ", " + Helper.getMemInfo());
        LOGGER.info("pass2 - start");
        StopWatch sw2 = new StopWatch().start();
        this.readOSM(osmFile, new Pass2Handler(), SkipOptions.none());
        LOGGER.info("pass2 - finished, took: {}", (Object)sw2.stop().getTimeString());
        this.nodeData.release();
        LOGGER.info("Finished reading OSM file. pass1: " + (int)sw1.getSeconds() + "s,  pass2: " + (int)sw2.getSeconds() + "s,  total: " + (int)(sw1.getSeconds() + sw2.getSeconds()) + "s");
    }

    public Date getTimeStamp() {
        return this.timestamp;
    }

    private void readOSM(File file, ReaderElementHandler handler, SkipOptions skipOptions) {
        try (OSMInput osmInput = this.openOsmInputFile(file, skipOptions);){
            ReaderElement elem;
            while ((elem = osmInput.getNext()) != null) {
                handler.handleElement(elem);
            }
            handler.onFinish();
            if (osmInput.getUnprocessedElements() > 0) {
                throw new IllegalStateException("There were some remaining elements in the reader queue " + osmInput.getUnprocessedElements());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse OSM file: " + file.getAbsolutePath(), e);
        }
    }

    protected OSMInput openOsmInputFile(File osmFile, SkipOptions skipOptions) throws XMLStreamException, IOException {
        return new OSMInputFile(osmFile).setWorkerThreads(this.workerThreads).setSkipOptions(skipOptions).open();
    }

    public static interface CoordinateSupplier {
        public GHPoint3D getCoordinate(long var1);
    }

    public static interface WayPreprocessor {
        public void preprocessWay(ReaderWay var1, CoordinateSupplier var2);
    }

    public static interface RelationProcessor {
        public void processRelation(ReaderRelation var1, LongToIntFunction var2);
    }

    public static interface EdgeHandler {
        public void handleEdge(int var1, int var2, PointList var3, ReaderWay var4, List<Map<String, Object>> var5);
    }

    private static interface ReaderElementHandler {
        default public void handleElement(ReaderElement elem) throws ParseException {
            switch (elem.getType()) {
                case NODE: {
                    this.handleNode((ReaderNode)elem);
                    break;
                }
                case WAY: {
                    this.handleWay((ReaderWay)elem);
                    break;
                }
                case RELATION: {
                    this.handleRelation((ReaderRelation)elem);
                    break;
                }
                case FILEHEADER: {
                    this.handleFileHeader((OSMFileHeader)elem);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown reader element type: " + (Object)((Object)elem.getType()));
                }
            }
        }

        default public void handleNode(ReaderNode node) {
        }

        default public void handleWay(ReaderWay way) {
        }

        default public void handleRelation(ReaderRelation relation) {
        }

        default public void handleFileHeader(OSMFileHeader fileHeader) throws ParseException {
        }

        default public void onFinish() {
        }
    }

    public static class Builder {
        private final WaySegmentParser waySegmentParser;

        public Builder(PointAccess pointAccess, Directory directory) {
            this.waySegmentParser = new WaySegmentParser(new OSMNodeData(pointAccess, directory));
        }

        public Builder setElevationProvider(ElevationProvider elevationProvider) {
            this.waySegmentParser.elevationProvider = elevationProvider;
            return this;
        }

        public Builder setWayFilter(Predicate<ReaderWay> wayFilter) {
            this.waySegmentParser.wayFilter = wayFilter;
            return this;
        }

        public Builder setSplitNodeFilter(Predicate<ReaderNode> splitNodeFilter) {
            this.waySegmentParser.splitNodeFilter = splitNodeFilter;
            return this;
        }

        public Builder setWayPreprocessor(WayPreprocessor wayPreprocessor) {
            this.waySegmentParser.wayPreprocessor = wayPreprocessor;
            return this;
        }

        public Builder setRelationPreprocessor(Consumer<ReaderRelation> relationPreprocessor) {
            this.waySegmentParser.relationPreprocessor = relationPreprocessor;
            return this;
        }

        public Builder setRelationProcessor(RelationProcessor relationProcessor) {
            this.waySegmentParser.relationProcessor = relationProcessor;
            return this;
        }

        public Builder setEdgeHandler(EdgeHandler edgeHandler) {
            this.waySegmentParser.edgeHandler = edgeHandler;
            return this;
        }

        public Builder setWorkerThreads(int workerThreads) {
            this.waySegmentParser.workerThreads = workerThreads;
            return this;
        }

        public WaySegmentParser build() {
            return this.waySegmentParser;
        }
    }

    private class Pass2Handler
    implements ReaderElementHandler {
        private boolean handledNodes;
        private boolean handledWays;
        private boolean handledRelations;
        private long nodeCounter = 0L;
        private long acceptedNodes = 0L;
        private long ignoredSplitNodes = 0L;
        private long wayCounter = 0L;

        private Pass2Handler() {
        }

        @Override
        public void handleNode(ReaderNode node) {
            long nodeType;
            if (!this.handledNodes) {
                LOGGER.info("pass2 - start reading OSM nodes");
                this.handledNodes = true;
            }
            if (this.handledWays) {
                throw new IllegalStateException("OSM node elements must be located before way elements in OSM file");
            }
            if (this.handledRelations) {
                throw new IllegalStateException("OSM node elements must be located before relation elements in OSM file");
            }
            if (++this.nodeCounter % 10000000L == 0L) {
                LOGGER.info("pass2 - processed nodes: " + Helper.nf((long)this.nodeCounter) + ", accepted nodes: " + Helper.nf((long)this.acceptedNodes) + ", " + Helper.getMemInfo());
            }
            if ((nodeType = WaySegmentParser.this.nodeData.addCoordinatesIfMapped(node.getId(), node.getLat(), node.getLon(), () -> WaySegmentParser.this.elevationProvider.getEle(node))) == -1L) {
                return;
            }
            ++this.acceptedNodes;
            if (WaySegmentParser.this.splitNodeFilter.test(node)) {
                if (nodeType == -2L) {
                    LOGGER.debug("OSM node {} at {},{} is a barrier node at a junction. The barrier will be ignored", new Object[]{node.getId(), Helper.round((double)node.getLat(), (int)7), Helper.round((double)node.getLon(), (int)7)});
                    ++this.ignoredSplitNodes;
                } else {
                    WaySegmentParser.this.nodeData.setSplitNode(node.getId());
                }
            }
            for (Map.Entry<String, Object> e : node.getTags().entrySet()) {
                if (!INCLUDE_IF_NODE_TAGS.contains(e.getKey())) continue;
                node.removeTag("created_by");
                node.removeTag("source");
                node.removeTag("note");
                node.removeTag("fixme");
                WaySegmentParser.this.nodeData.setTags(node);
                break;
            }
        }

        @Override
        public void handleWay(ReaderWay way) {
            if (!this.handledWays) {
                LOGGER.info("pass2 - start reading OSM ways");
                this.handledWays = true;
            }
            if (this.handledRelations) {
                throw new IllegalStateException("OSM way elements must be located before relation elements in OSM file");
            }
            if (++this.wayCounter % 10000000L == 0L) {
                LOGGER.info("pass2 - processed ways: " + Helper.nf((long)this.wayCounter) + ", " + Helper.getMemInfo());
            }
            if (!WaySegmentParser.this.wayFilter.test(way)) {
                return;
            }
            ArrayList<SegmentNode> segment = new ArrayList<SegmentNode>(way.getNodes().size());
            for (LongCursor node : way.getNodes()) {
                segment.add(new SegmentNode(node.value, WaySegmentParser.this.nodeData.getId(node.value), WaySegmentParser.this.nodeData.getTags(node.value)));
            }
            WaySegmentParser.this.wayPreprocessor.preprocessWay(way, osmNodeId -> WaySegmentParser.this.nodeData.getCoordinates(WaySegmentParser.this.nodeData.getId(osmNodeId)));
            this.splitWayAtJunctionsAndEmptySections(segment, way);
        }

        private void splitWayAtJunctionsAndEmptySections(List<SegmentNode> fullSegment, ReaderWay way) {
            ArrayList<SegmentNode> segment = new ArrayList<SegmentNode>();
            for (SegmentNode node : fullSegment) {
                if (!OSMNodeData.isNodeId(node.id)) {
                    if (segment.size() <= 1) continue;
                    this.splitLoopSegments(segment, way);
                    segment = new ArrayList();
                    continue;
                }
                if (OSMNodeData.isTowerNode(node.id)) {
                    if (!segment.isEmpty()) {
                        segment.add(node);
                        this.splitLoopSegments(segment, way);
                        segment = new ArrayList();
                    }
                    segment.add(node);
                    continue;
                }
                segment.add(node);
            }
            if (segment.size() > 1) {
                this.splitLoopSegments(segment, way);
            }
        }

        private void splitLoopSegments(List<SegmentNode> segment, ReaderWay way) {
            boolean isLoop;
            if (segment.size() < 2) {
                throw new IllegalStateException("Segment size must be >= 2, but was: " + segment.size());
            }
            boolean bl = isLoop = segment.get((int)0).osmNodeId == segment.get((int)(segment.size() - 1)).osmNodeId;
            if (segment.size() == 2 && isLoop) {
                LOGGER.warn("Loop in OSM way: {}, will be ignored, duplicate node: {}", (Object)way.getId(), (Object)segment.get((int)0).osmNodeId);
            } else if (isLoop) {
                this.splitSegmentAtSplitNodes(segment.subList(0, segment.size() - 1), way);
                this.splitSegmentAtSplitNodes(segment.subList(segment.size() - 2, segment.size()), way);
            } else {
                this.splitSegmentAtSplitNodes(segment, way);
            }
        }

        private void splitSegmentAtSplitNodes(List<SegmentNode> parentSegment, ReaderWay way) {
            ArrayList<SegmentNode> segment = new ArrayList<SegmentNode>();
            for (int i = 0; i < parentSegment.size(); ++i) {
                SegmentNode node = parentSegment.get(i);
                if (WaySegmentParser.this.nodeData.isSplitNode(node.osmNodeId)) {
                    WaySegmentParser.this.nodeData.unsetSplitNode(node.osmNodeId);
                    SegmentNode barrierFrom = node;
                    SegmentNode barrierTo = WaySegmentParser.this.nodeData.addCopyOfNode(node);
                    if (i == parentSegment.size() - 1) {
                        SegmentNode tmp = barrierFrom;
                        barrierFrom = barrierTo;
                        barrierTo = tmp;
                    }
                    if (!segment.isEmpty()) {
                        segment.add(barrierFrom);
                        this.handleSegment(segment, way);
                        segment = new ArrayList();
                    }
                    way.setTag("gh:barrier_edge", true);
                    segment.add(barrierFrom);
                    segment.add(barrierTo);
                    this.handleSegment(segment, way);
                    way.removeTag("gh:barrier_edge");
                    segment = new ArrayList();
                    segment.add(barrierTo);
                    continue;
                }
                segment.add(node);
            }
            if (segment.size() > 1) {
                this.handleSegment(segment, way);
            }
        }

        void handleSegment(List<SegmentNode> segment, ReaderWay way) {
            PointList pointList = new PointList(segment.size(), WaySegmentParser.this.nodeData.is3D());
            ArrayList<Map<String, Object>> nodeTags = new ArrayList<Map<String, Object>>(segment.size());
            int from = -1;
            int to = -1;
            for (int i = 0; i < segment.size(); ++i) {
                SegmentNode node = segment.get(i);
                long id = node.id;
                if (!OSMNodeData.isNodeId(id)) {
                    throw new IllegalStateException("Invalid id for node: " + node.osmNodeId + " when handling segment " + segment + " for way: " + way.getId());
                }
                if (OSMNodeData.isPillarNode(id) && (i == 0 || i == segment.size() - 1)) {
                    node.id = id = WaySegmentParser.this.nodeData.convertPillarToTowerNode(id, node.osmNodeId);
                }
                if (i == 0) {
                    from = WaySegmentParser.this.nodeData.idToTowerNode(id);
                } else if (i == segment.size() - 1) {
                    to = WaySegmentParser.this.nodeData.idToTowerNode(id);
                } else if (OSMNodeData.isTowerNode(id)) {
                    throw new IllegalStateException("Tower nodes should only appear at the end of segments, way: " + way.getId());
                }
                WaySegmentParser.this.nodeData.addCoordinatesToPointList(id, pointList);
                nodeTags.add(node.tags);
            }
            if (from < 0 || to < 0) {
                throw new IllegalStateException("The first and last nodes of a segment must be tower nodes, way: " + way.getId());
            }
            WaySegmentParser.this.edgeHandler.handleEdge(from, to, pointList, way, nodeTags);
        }

        @Override
        public void handleRelation(ReaderRelation relation) {
            if (!this.handledRelations) {
                LOGGER.info("pass2 - start reading OSM relations");
                this.handledRelations = true;
            }
            WaySegmentParser.this.relationProcessor.processRelation(relation, this::getInternalNodeIdOfOSMNode);
        }

        @Override
        public void onFinish() {
            LOGGER.info("pass2 - finished, processed ways: {}, way nodes: {}, nodes with tags: {}, node tag capacity: {}, ignored barriers at junctions: {}", new Object[]{Helper.nf((long)this.wayCounter), Helper.nf((long)this.acceptedNodes), Helper.nf((long)WaySegmentParser.this.nodeData.getTaggedNodeCount()), Helper.nf((long)WaySegmentParser.this.nodeData.getNodeTagCapacity()), Helper.nf((long)this.ignoredSplitNodes)});
        }

        public int getInternalNodeIdOfOSMNode(long nodeOsmId) {
            long id = WaySegmentParser.this.nodeData.getId(nodeOsmId);
            if (OSMNodeData.isTowerNode(id)) {
                return -((int)id) - 3;
            }
            return -1;
        }
    }

    private class Pass1Handler
    implements ReaderElementHandler {
        private boolean handledWays;
        private boolean handledRelations;
        private long wayCounter = 0L;
        private long acceptedWays = 0L;
        private long relationsCounter = 0L;

        private Pass1Handler() {
        }

        @Override
        public void handleWay(ReaderWay way) {
            if (!this.handledWays) {
                LOGGER.info("pass1 - start reading OSM ways");
                this.handledWays = true;
            }
            if (this.handledRelations) {
                throw new IllegalStateException("OSM way elements must be located before relation elements in OSM file");
            }
            if (++this.wayCounter % 10000000L == 0L) {
                LOGGER.info("pass1 - processed ways: " + Helper.nf((long)this.wayCounter) + ", accepted ways: " + Helper.nf((long)this.acceptedWays) + ", way nodes: " + Helper.nf((long)WaySegmentParser.this.nodeData.getNodeCount()) + ", " + Helper.getMemInfo());
            }
            if (!WaySegmentParser.this.wayFilter.test(way)) {
                return;
            }
            ++this.acceptedWays;
            for (LongCursor node : way.getNodes()) {
                boolean isEnd = node.index == 0 || node.index == way.getNodes().size() - 1;
                long osmId = node.value;
                WaySegmentParser.this.nodeData.setOrUpdateNodeType(osmId, isEnd ? 0L : 1L, prev -> prev == 0L && isEnd ? 2L : -2L);
            }
        }

        @Override
        public void handleRelation(ReaderRelation relation) {
            if (!this.handledRelations) {
                LOGGER.info("pass1 - start reading OSM relations");
                this.handledRelations = true;
            }
            if (++this.relationsCounter % 1000000L == 0L) {
                LOGGER.info("pass1 - processed relations: " + Helper.nf((long)this.relationsCounter) + ", " + Helper.getMemInfo());
            }
            WaySegmentParser.this.relationPreprocessor.accept(relation);
        }

        @Override
        public void handleFileHeader(OSMFileHeader fileHeader) throws ParseException {
            WaySegmentParser.this.timestamp = Helper.createFormatter().parse(fileHeader.getTag("timestamp"));
        }

        @Override
        public void onFinish() {
            LOGGER.info("pass1 - finished, processed ways: " + Helper.nf((long)this.wayCounter) + ", accepted ways: " + Helper.nf((long)this.acceptedWays) + ", way nodes: " + Helper.nf((long)WaySegmentParser.this.nodeData.getNodeCount()) + ", relations: " + Helper.nf((long)this.relationsCounter) + ", " + Helper.getMemInfo());
        }
    }
}

