/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIteratorState;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRoutingAlgorithm
implements RoutingAlgorithm {
    protected final Graph graph;
    protected final Weighting weighting;
    protected final TraversalMode traversalMode;
    protected final NodeAccess nodeAccess;
    protected final EdgeExplorer edgeExplorer;
    protected int maxVisitedNodes = Integer.MAX_VALUE;
    protected long timeoutMillis = Long.MAX_VALUE;
    private long finishTimeMillis = Long.MAX_VALUE;
    private boolean alreadyRun;

    public AbstractRoutingAlgorithm(Graph graph, Weighting weighting, TraversalMode traversalMode) {
        if (weighting.hasTurnCosts() && !traversalMode.isEdgeBased()) {
            throw new IllegalStateException("Weightings supporting turn costs cannot be used with node-based traversal mode");
        }
        this.weighting = weighting;
        this.traversalMode = traversalMode;
        this.graph = graph;
        this.nodeAccess = graph.getNodeAccess();
        this.edgeExplorer = graph.createEdgeExplorer();
    }

    @Override
    public void setMaxVisitedNodes(int numberOfNodes) {
        this.maxVisitedNodes = numberOfNodes;
    }

    @Override
    public void setTimeoutMillis(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    protected boolean accept(EdgeIteratorState iter, int prevOrNextEdgeId) {
        return this.traversalMode.isEdgeBased() || iter.getEdge() != prevOrNextEdgeId;
    }

    protected void checkAlreadyRun() {
        if (this.alreadyRun) {
            throw new IllegalStateException("Create a new instance per call");
        }
        this.alreadyRun = true;
    }

    protected void setupFinishTime() {
        try {
            this.finishTimeMillis = Math.addExact(System.currentTimeMillis(), this.timeoutMillis);
        }
        catch (ArithmeticException e) {
            this.finishTimeMillis = Long.MAX_VALUE;
        }
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        return Collections.singletonList(this.calcPath(from, to));
    }

    protected Path createEmptyPath() {
        return new Path(this.graph);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getName() + "|" + this.weighting;
    }

    protected boolean isMaxVisitedNodesExceeded() {
        return this.maxVisitedNodes < this.getVisitedNodes();
    }

    protected boolean isTimeoutExceeded() {
        return this.finishTimeMillis < Long.MAX_VALUE && System.currentTimeMillis() > this.finishTimeMillis;
    }
}

