/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.apache.commons.collections.IntFloatBinaryHeap;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import java.util.Arrays;

public class NodeBasedWitnessPathSearcher {
    private final PrepareGraphEdgeExplorer outEdgeExplorer;
    private final double[] weights;
    private final IntArrayList changedNodes;
    private final IntFloatBinaryHeap heap;
    private int ignoreNode = -1;
    private int settledNodes = 0;

    public NodeBasedWitnessPathSearcher(CHPreparationGraph graph) {
        this.outEdgeExplorer = graph.createOutEdgeExplorer();
        this.weights = new double[graph.getNodes()];
        Arrays.fill(this.weights, Double.POSITIVE_INFINITY);
        this.heap = new IntFloatBinaryHeap(1000);
        this.changedNodes = new IntArrayList();
    }

    public void init(int startNode, int ignoreNode) {
        this.reset();
        this.ignoreNode = ignoreNode;
        this.weights[startNode] = 0.0;
        this.changedNodes.add(startNode);
        this.heap.insert(0.0, startNode);
    }

    public double findUpperBound(int targetNode, double acceptedWeight, int maxSettledNodes) {
        while (!this.heap.isEmpty() && this.settledNodes < maxSettledNodes && (double)this.heap.peekKey() <= acceptedWeight) {
            if (this.weights[targetNode] <= acceptedWeight) {
                return this.weights[targetNode];
            }
            int node = this.heap.poll();
            PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(node);
            while (iter.next()) {
                double weight;
                int adjNode = iter.getAdjNode();
                if (adjNode == this.ignoreNode || Double.isInfinite(weight = this.weights[node] + iter.getWeight())) continue;
                double adjWeight = this.weights[adjNode];
                if (adjWeight == Double.POSITIVE_INFINITY) {
                    this.weights[adjNode] = weight;
                    this.heap.insert(weight, adjNode);
                    this.changedNodes.add(adjNode);
                    continue;
                }
                if (!(weight < adjWeight)) continue;
                this.weights[adjNode] = weight;
                this.heap.update(weight, adjNode);
            }
            ++this.settledNodes;
            if (node != targetNode) continue;
            return this.weights[node];
        }
        return this.weights[targetNode];
    }

    public int getSettledNodes() {
        return this.settledNodes;
    }

    private void reset() {
        for (IntCursor c : this.changedNodes) {
            this.weights[c.value] = Double.POSITIVE_INFINITY;
        }
        this.changedNodes.elementsCount = 0;
        this.heap.clear();
        this.ignoreNode = -1;
        this.settledNodes = 0;
    }

    public String getMemoryUsageAsString() {
        return (8L * (long)this.weights.length + (long)this.changedNodes.buffer.length * 4L + this.heap.getMemoryUsage()) / 0x100000L + "MB";
    }
}

