/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.BitSetIterator;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.subnetwork.EdgeBasedTarjanSCC;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.StopWatch;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRoutingSubnetworks {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BaseGraph graph;
    private final List<PrepareJob> prepareJobs;
    private int minNetworkSize = 200;
    private int threads = 1;

    public PrepareRoutingSubnetworks(BaseGraph graph, List<PrepareJob> prepareJobs) {
        this.graph = graph;
        this.prepareJobs = prepareJobs;
    }

    public PrepareRoutingSubnetworks setMinNetworkSize(int minNetworkSize) {
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public PrepareRoutingSubnetworks setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public int doWork() {
        if (this.minNetworkSize <= 0) {
            this.logger.info("Skipping subnetwork search: prepare.min_network_size: " + this.minNetworkSize);
            return 0;
        }
        StopWatch sw = new StopWatch().start();
        this.logger.info("Start marking subnetworks, prepare.min_network_size: " + this.minNetworkSize + ", threads: " + this.threads + ", nodes: " + Helper.nf((long)this.graph.getNodes()) + ", edges: " + Helper.nf((long)this.graph.getEdges()) + ", jobs: " + this.prepareJobs + ", " + Helper.getMemInfo());
        AtomicInteger total = new AtomicInteger(0);
        List flags = Stream.generate(() -> new BitSet((long)this.graph.getEdges())).limit(this.prepareJobs.size()).collect(Collectors.toList());
        Stream<Runnable> runnables = IntStream.range(0, this.prepareJobs.size()).mapToObj(i -> () -> {
            PrepareJob job = this.prepareJobs.get(i);
            total.addAndGet(this.setSubnetworks(job.weighting, job.subnetworkEnc.getName().replaceAll("_subnetwork", ""), (BitSet)flags.get(i)));
        });
        GHUtility.runConcurrently(runnables, this.threads);
        AllEdgesIterator iter = this.graph.getAllEdges();
        while (iter.next()) {
            for (int i2 = 0; i2 < this.prepareJobs.size(); ++i2) {
                PrepareJob prepareJob = this.prepareJobs.get(i2);
                iter.set(prepareJob.subnetworkEnc, ((BitSet)flags.get(i2)).get(iter.getEdge()));
            }
        }
        this.logger.info("Finished finding and marking subnetworks for " + this.prepareJobs.size() + " jobs, took: " + sw.stop().getSeconds() + "s, " + Helper.getMemInfo());
        return total.get();
    }

    private int setSubnetworks(Weighting weighting, String jobName, BitSet subnetworkFlags) {
        int allowedMarked;
        StopWatch sw = new StopWatch().start();
        EdgeBasedTarjanSCC.ConnectedComponents ccs = EdgeBasedTarjanSCC.findComponents(this.graph, (prev, edge) -> Double.isFinite(GHUtility.calcWeightWithTurnWeight(weighting, edge, false, prev)), false);
        List<IntArrayList> components = ccs.getComponents();
        BitSet singleEdgeComponents = ccs.getSingleEdgeComponents();
        long numSingleEdgeComponents = singleEdgeComponents.cardinality();
        this.logger.info(jobName + " - Found " + ccs.getTotalComponents() + " subnetworks (" + numSingleEdgeComponents + " single edges and " + components.size() + " components with more than one edge, total nodes: " + ccs.getEdgeKeys() + "), took: " + sw.stop().getSeconds() + "s");
        int minNetworkSizeEdgeKeys = 2 * this.minNetworkSize;
        sw = new StopWatch().start();
        int subnetworks = 0;
        int markedEdges = 0;
        int smallestNonSubnetwork = ccs.getBiggestComponent().size();
        int biggestSubnetwork = 0;
        for (IntArrayList component : components) {
            if (component == ccs.getBiggestComponent()) continue;
            if (component.size() < minNetworkSizeEdgeKeys) {
                for (IntCursor cursor : component) {
                    markedEdges += this.setSubnetworkEdge(cursor.value, weighting, subnetworkFlags);
                }
                ++subnetworks;
                biggestSubnetwork = Math.max(biggestSubnetwork, component.size());
                continue;
            }
            smallestNonSubnetwork = Math.min(smallestNonSubnetwork, component.size());
        }
        if (minNetworkSizeEdgeKeys > 0) {
            BitSetIterator iter = singleEdgeComponents.iterator();
            int edgeKey = iter.nextSetBit();
            while (edgeKey >= 0) {
                markedEdges += this.setSubnetworkEdge(edgeKey, weighting, subnetworkFlags);
                ++subnetworks;
                biggestSubnetwork = Math.max(biggestSubnetwork, 1);
                edgeKey = iter.nextSetBit();
            }
        } else if (numSingleEdgeComponents > 0L) {
            smallestNonSubnetwork = Math.min(smallestNonSubnetwork, 1);
        }
        if (markedEdges / 2 > (allowedMarked = this.graph.getEdges() / 2)) {
            throw new IllegalStateException("Too many total (directed) edges were marked as subnetwork edges: " + markedEdges + " out of " + 2 * this.graph.getEdges() + "\nThe maximum number of subnetwork edges is: " + 2 * allowedMarked);
        }
        this.logger.info(jobName + " - Marked " + subnetworks + " subnetworks (biggest: " + biggestSubnetwork + " edges) -> " + (ccs.getTotalComponents() - subnetworks) + " components(s) remain (smallest: " + smallestNonSubnetwork + ", biggest: " + ccs.getBiggestComponent().size() + " edges), total marked edges: " + markedEdges + ", took: " + sw.stop().getSeconds() + "s");
        return markedEdges;
    }

    private int setSubnetworkEdge(int edgeKey, Weighting weighting, BitSet subnetworkFlags) {
        if (!Double.isFinite(weighting.calcEdgeWeight(this.graph.getEdgeIteratorStateForKey(edgeKey), false))) {
            return 0;
        }
        int edge = GHUtility.getEdgeFromEdgeKey(edgeKey);
        if (!subnetworkFlags.get(edge)) {
            subnetworkFlags.set((long)edge);
            return 1;
        }
        return 0;
    }

    public static class PrepareJob {
        private final BooleanEncodedValue subnetworkEnc;
        private final Weighting weighting;

        public PrepareJob(BooleanEncodedValue subnetworkEnc, Weighting weighting) {
            this.weighting = weighting;
            this.subnetworkEnc = subnetworkEnc;
        }

        public String toString() {
            return this.subnetworkEnc.getName() + "|" + this.weighting;
        }
    }
}

