/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;

public class FerrySpeedCalculator
implements TagParser {
    private final DecimalEncodedValue ferrySpeedEnc;

    public FerrySpeedCalculator(DecimalEncodedValue ferrySpeedEnc) {
        this.ferrySpeedEnc = ferrySpeedEnc;
    }

    public static boolean isFerry(ReaderWay way) {
        return way.hasTag("route", (Object)"ferry") && !way.hasTag("ferry", (Object)"no") || way.hasTag("route", (Object)"shuttle_train") && !way.hasTag("shuttle_train", (Object)"no");
    }

    static double getSpeed(ReaderWay way) {
        double speedInKmPerHour = way.getTag("speed_from_duration", Double.NaN);
        if (!Double.isNaN(speedInKmPerHour)) {
            return Math.round(speedInKmPerHour / 1.4);
        }
        double wayDistance = way.getTag("edge_distance", Double.NaN);
        if (Double.isNaN(wayDistance)) {
            throw new IllegalStateException("No 'edge_distance' set for edge created for way: " + way.getId());
        }
        if (wayDistance < 500.0) {
            return 1.0;
        }
        return 6.0;
    }

    public static double minmax(double speed, DecimalEncodedValue avgSpeedEnc) {
        return Math.max(avgSpeedEnc.getSmallestNonZeroValue(), Math.min(speed, avgSpeedEnc.getMaxStorableDecimal()));
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        if (FerrySpeedCalculator.isFerry(way)) {
            double ferrySpeed = FerrySpeedCalculator.minmax(FerrySpeedCalculator.getSpeed(way), this.ferrySpeedEnc);
            this.ferrySpeedEnc.setDecimal(false, edgeId, edgeIntAccess, ferrySpeed);
        }
    }
}

