/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.osm.conditional.DateRangeParser;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.BikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikePriorityParser;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.routing.util.parsers.CarAverageSpeedParser;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.routing.util.parsers.FootPriorityParser;
import com.graphhopper.routing.util.parsers.MountainBikeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.MountainBikePriorityParser;
import com.graphhopper.routing.util.parsers.RacingBikeAccessParser;
import com.graphhopper.routing.util.parsers.RacingBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.RacingBikePriorityParser;
import com.graphhopper.routing.util.parsers.RoadsAccessParser;
import com.graphhopper.routing.util.parsers.RoadsAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.util.parsers.WheelchairAccessParser;
import com.graphhopper.routing.util.parsers.WheelchairAverageSpeedParser;
import com.graphhopper.routing.util.parsers.WheelchairPriorityParser;
import com.graphhopper.util.PMap;
import java.util.Arrays;
import java.util.List;

public class VehicleTagParsers {
    private final TagParser accessParser;
    private final TagParser speedParser;
    private final TagParser priorityParser;

    public static VehicleTagParsers roads(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new RoadsAccessParser(lookup, properties), new RoadsAverageSpeedParser(lookup, properties), null);
    }

    public static VehicleTagParsers car(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new CarAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new CarAverageSpeedParser(lookup, properties), null);
    }

    public static VehicleTagParsers bike(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new BikeAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new BikeAverageSpeedParser(lookup, properties), new BikePriorityParser(lookup, properties));
    }

    public static VehicleTagParsers racingbike(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new RacingBikeAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new RacingBikeAverageSpeedParser(lookup, properties), new RacingBikePriorityParser(lookup, properties));
    }

    public static VehicleTagParsers mtb(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new MountainBikeAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new MountainBikeAverageSpeedParser(lookup, properties), new MountainBikePriorityParser(lookup, properties));
    }

    public static VehicleTagParsers foot(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new FootAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new FootAverageSpeedParser(lookup, properties), new FootPriorityParser(lookup, properties));
    }

    public static VehicleTagParsers wheelchair(EncodedValueLookup lookup, PMap properties) {
        return new VehicleTagParsers(new WheelchairAccessParser(lookup, properties).init((DateRangeParser)properties.getObject("date_range_parser", (Object)new DateRangeParser())), new WheelchairAverageSpeedParser(lookup, properties), new WheelchairPriorityParser(lookup, properties));
    }

    public VehicleTagParsers(TagParser accessParser, TagParser speedParser, TagParser priorityParser) {
        this.accessParser = accessParser;
        this.speedParser = speedParser;
        this.priorityParser = priorityParser;
    }

    public TagParser getAccessParser() {
        return this.accessParser;
    }

    public TagParser getSpeedParser() {
        return this.speedParser;
    }

    public TagParser getPriorityParser() {
        return this.priorityParser;
    }

    public List<TagParser> getTagParsers() {
        return this.priorityParser == null ? Arrays.asList(this.accessParser, this.speedParser) : Arrays.asList(this.accessParser, this.speedParser, this.priorityParser);
    }
}

