/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.PMap;
import java.util.HashMap;
import java.util.Map;

public class FootAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    static final int SLOW_SPEED = 2;
    static final int MEAN_SPEED = 5;
    protected Map<RouteNetwork, Integer> routeMap = new HashMap<RouteNetwork, Integer>();

    public FootAverageSpeedParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "foot"))), lookup.getDecimalEncodedValue("ferry_speed"));
    }

    protected FootAverageSpeedParser(DecimalEncodedValue speedEnc, DecimalEncodedValue ferrySpeedEnc) {
        super(speedEnc, ferrySpeedEnc);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.UNCHANGED.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.UNCHANGED.getValue());
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        String sacScale;
        String highwayValue = way.getTag("highway");
        if (highwayValue == null) {
            if (FerrySpeedCalculator.isFerry(way)) {
                double ferrySpeed = FerrySpeedCalculator.minmax(this.ferrySpeedEnc.getDecimal(false, edgeId, edgeIntAccess), this.avgSpeedEnc);
                this.setSpeed(false, edgeId, edgeIntAccess, ferrySpeed);
                if (this.avgSpeedEnc.isStoreTwoDirections()) {
                    this.setSpeed(true, edgeId, edgeIntAccess, ferrySpeed);
                }
            }
            if (!way.hasTag("railway", (Object)"platform") && !way.hasTag("man_made", (Object)"pier")) {
                return;
            }
        }
        if ((sacScale = way.getTag("sac_scale")) != null) {
            this.setSpeed(false, edgeId, edgeIntAccess, "hiking".equals(sacScale) ? 5.0 : 2.0);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.setSpeed(true, edgeId, edgeIntAccess, "hiking".equals(sacScale) ? 5.0 : 2.0);
            }
        } else {
            this.setSpeed(false, edgeId, edgeIntAccess, way.hasTag("highway", (Object)"steps") ? 3.0 : 5.0);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.setSpeed(true, edgeId, edgeIntAccess, way.hasTag("highway", (Object)"steps") ? 3.0 : 5.0);
            }
        }
    }
}

