/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.parsers.BikeCommonPriorityParser;
import com.graphhopper.util.PMap;
import java.util.TreeMap;

public class MountainBikePriorityParser
extends BikeCommonPriorityParser {
    public MountainBikePriorityParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key(properties.getString("name", "mtb"))), lookup.getDecimalEncodedValue(VehiclePriority.key(properties.getString("name", "mtb"))), lookup.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class));
    }

    protected MountainBikePriorityParser(DecimalEncodedValue speedEnc, DecimalEncodedValue priorityEnc, EnumEncodedValue<RouteNetwork> bikeRouteEnc) {
        super(priorityEnc, speedEnc, bikeRouteEnc);
        this.routeMap.put(RouteNetwork.INTERNATIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.NATIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.REGIONAL, PriorityCode.PREFER.getValue());
        this.routeMap.put(RouteNetwork.LOCAL, PriorityCode.BEST.getValue());
        this.preferHighwayTags.add("road");
        this.preferHighwayTags.add("track");
        this.preferHighwayTags.add("path");
        this.preferHighwayTags.add("service");
        this.preferHighwayTags.add("tertiary");
        this.preferHighwayTags.add("tertiary_link");
        this.preferHighwayTags.add("residential");
        this.preferHighwayTags.add("unclassified");
        this.setSpecificClassBicycle("mtb");
    }

    @Override
    void collect(ReaderWay way, double wayTypeSpeed, TreeMap<Double, PriorityCode> weightToPrioMap) {
        super.collect(way, wayTypeSpeed, weightToPrioMap);
        String highway = way.getTag("highway");
        if ("track".equals(highway)) {
            String trackType = way.getTag("tracktype");
            if ("grade1".equals(trackType)) {
                weightToPrioMap.put(50.0, PriorityCode.UNCHANGED);
            } else if (trackType == null) {
                weightToPrioMap.put(90.0, PriorityCode.PREFER);
            } else if (trackType.startsWith("grade")) {
                weightToPrioMap.put(100.0, PriorityCode.VERY_NICE);
            }
        }
    }
}

