/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.Crossing;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;
import java.util.List;
import java.util.Map;

public class OSMCrossingParser
implements TagParser {
    protected final EnumEncodedValue<Crossing> crossingEnc;

    public OSMCrossingParser(EnumEncodedValue<Crossing> crossingEnc) {
        this.crossingEnc = crossingEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay readerWay, IntsRef relationFlags) {
        List nodeTags = readerWay.getTag("node_tags", null);
        if (nodeTags == null) {
            return;
        }
        for (int i = 0; i < nodeTags.size(); ++i) {
            Map tags = (Map)nodeTags.get(i);
            if ("crossing".equals(tags.get("railway")) || "level_crossing".equals(tags.get("railway"))) {
                String barrierVal = (String)tags.get("crossing:barrier");
                this.crossingEnc.setEnum(false, edgeId, edgeIntAccess, Helper.isEmpty((String)barrierVal) || "no".equals(barrierVal) ? Crossing.RAILWAY : Crossing.RAILWAY_BARRIER);
                return;
            }
            String crossingSignals = (String)tags.get("crossing:signals");
            if ("yes".equals(crossingSignals)) {
                this.crossingEnc.setEnum(false, edgeId, edgeIntAccess, Crossing.TRAFFIC_SIGNALS);
                return;
            }
            String crossingMarkings = (String)tags.get("crossing:markings");
            if ("yes".equals(crossingMarkings)) {
                this.crossingEnc.setEnum(false, edgeId, edgeIntAccess, Crossing.MARKED);
                return;
            }
            String crossingValue = (String)tags.get("crossing");
            if (Helper.isEmpty((String)crossingValue) && ("no".equals(crossingSignals) || "no".equals(crossingMarkings) || "crossing".equals(tags.get("highway")) || "crossing".equals(tags.get("footway")) || "crossing".equals(tags.get("cycleway")))) {
                this.crossingEnc.setEnum(false, edgeId, edgeIntAccess, Crossing.UNMARKED);
                continue;
            }
            Crossing crossing = Crossing.find(crossingValue);
            if (crossing == Crossing.MISSING) continue;
            this.crossingEnc.setEnum(false, edgeId, edgeIntAccess, crossing);
        }
    }
}

