/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.WayAccess;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.util.PMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class WheelchairAccessParser
extends FootAccessParser {
    private final Set<String> excludeSurfaces = new HashSet<String>();
    private final Set<String> excludeSmoothness = new HashSet<String>();
    private final int maxInclinePercent = 6;

    public WheelchairAccessParser(EncodedValueLookup lookup, PMap properties) {
        this(lookup.getBooleanEncodedValue(properties.getString("name", VehicleAccess.key("wheelchair"))));
        this.blockPrivate(properties.getBool("block_private", true));
        this.blockFords(properties.getBool("block_fords", false));
    }

    protected WheelchairAccessParser(BooleanEncodedValue accessEnc) {
        super(accessEnc);
        this.restrictions.add("wheelchair");
        this.barriers.add("handrail");
        this.barriers.add("wall");
        this.barriers.add("turnstile");
        this.barriers.add("kissing_gate");
        this.barriers.add("stile");
        this.allowedHighwayTags.remove("steps");
        this.allowedHighwayTags.remove("track");
        this.excludeSurfaces.add("cobblestone");
        this.excludeSurfaces.add("gravel");
        this.excludeSurfaces.add("sand");
        this.excludeSmoothness.add("bad");
        this.excludeSmoothness.add("very_bad");
        this.excludeSmoothness.add("horrible");
        this.excludeSmoothness.add("very_horrible");
        this.excludeSmoothness.add("impassable");
        this.allowedSacScale.clear();
    }

    @Override
    public WayAccess getAccess(ReaderWay way) {
        String tagValue;
        String sidewalk;
        if (way.hasTag("surface", this.excludeSurfaces)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return WayAccess.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":surface", this.excludeSurfaces)) {
                return WayAccess.CAN_SKIP;
            }
        }
        if (way.hasTag("smoothness", this.excludeSmoothness)) {
            if (!way.hasTag("sidewalk", (Collection<String>)this.sidewalkValues)) {
                return WayAccess.CAN_SKIP;
            }
            sidewalk = way.getTag("sidewalk");
            if (way.hasTag("sidewalk:" + sidewalk + ":smoothness", this.excludeSmoothness)) {
                return WayAccess.CAN_SKIP;
            }
        }
        if (way.hasTag("incline", new String[0]) && ((tagValue = way.getTag("incline")).endsWith("%") || tagValue.endsWith("\u00b0"))) {
            try {
                double incline = Double.parseDouble(tagValue.substring(0, tagValue.length() - 1));
                if (tagValue.endsWith("\u00b0")) {
                    incline = Math.tan(incline * Math.PI / 180.0) * 100.0;
                }
                if (-6.0 > incline || incline > 6.0) {
                    return WayAccess.CAN_SKIP;
                }
            }
            catch (NumberFormatException incline) {
                // empty catch block
            }
        }
        if (way.hasTag("kerb", (Object)"raised")) {
            return WayAccess.CAN_SKIP;
        }
        if (way.hasTag("kerb", new String[0]) && ((tagValue = way.getTag("kerb")).endsWith("cm") || tagValue.endsWith("mm"))) {
            try {
                int maxKerbHeightCm;
                float kerbHeight = Float.parseFloat(tagValue.substring(0, tagValue.length() - 2));
                if (tagValue.endsWith("mm")) {
                    kerbHeight /= 100.0f;
                }
                if (kerbHeight > (float)(maxKerbHeightCm = 3)) {
                    return WayAccess.CAN_SKIP;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.getAccess(way);
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        WayAccess access = this.getAccess(way);
        if (access.canSkip()) {
            return;
        }
        this.accessEnc.setBool(false, edgeId, edgeIntAccess, true);
        this.accessEnc.setBool(true, edgeId, edgeIntAccess, true);
    }
}

