/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.custom.ValueExpressionVisitor;
import com.graphhopper.util.CustomModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FindMinMax {
    public static void checkLMConstraints(CustomModel baseModel, CustomModel queryModel, EncodedValueLookup lookup) {
        if (queryModel.isInternal()) {
            throw new IllegalArgumentException("CustomModel of query cannot be internal");
        }
        if (queryModel.getDistanceInfluence() != null) {
            double bmDI;
            double d = bmDI = baseModel.getDistanceInfluence() == null ? 0.0 : baseModel.getDistanceInfluence();
            if (queryModel.getDistanceInfluence() < bmDI) {
                throw new IllegalArgumentException("CustomModel in query can only use distance_influence bigger or equal to " + bmDI + ", but was: " + queryModel.getDistanceInfluence());
            }
        }
        FindMinMax.checkMultiplyValue(queryModel.getPriority(), lookup);
        FindMinMax.checkMultiplyValue(queryModel.getSpeed(), lookup);
    }

    private static void checkMultiplyValue(List<Statement> list, EncodedValueLookup lookup) {
        HashSet<String> createdObjects = new HashSet<String>();
        for (Statement statement : list) {
            if (statement.getOperation() != Statement.Op.MULTIPLY) continue;
            MinMax minMax = ValueExpressionVisitor.findMinMax(createdObjects, statement.getValue(), lookup);
            if (minMax.max > 1.0) {
                throw new IllegalArgumentException("maximum of value '" + statement.getValue() + "' cannot be larger than 1, but was: " + minMax.max);
            }
            if (!(minMax.min < 0.0)) continue;
            throw new IllegalArgumentException("minimum of value '" + statement.getValue() + "' cannot be smaller than 0, but was: " + minMax.min);
        }
    }

    static MinMax findMinMax(Set<String> createdObjects, MinMax minMax, List<Statement> statements, EncodedValueLookup lookup) {
        List<List<Statement>> blocks = FindMinMax.splitIntoBlocks(statements);
        for (List<Statement> block : blocks) {
            FindMinMax.findMinMaxForBlock(createdObjects, minMax, block, lookup);
        }
        return minMax;
    }

    private static void findMinMaxForBlock(Set<String> createdObjects, MinMax minMax, List<Statement> block, EncodedValueLookup lookup) {
        MinMax minMaxBlock;
        if (block.isEmpty() || !Statement.Keyword.IF.equals((Object)block.get(0).getKeyword())) {
            throw new IllegalArgumentException("Every block must start with an if-statement");
        }
        if (block.get(0).getCondition().trim().equals("true")) {
            minMaxBlock = block.get(0).getOperation().apply(minMax, ValueExpressionVisitor.findMinMax(createdObjects, block.get(0).getValue(), lookup));
        } else {
            minMaxBlock = new MinMax(Double.MAX_VALUE, 0.0);
            boolean foundElse = false;
            for (Statement s : block) {
                if (s.getKeyword() == Statement.Keyword.ELSE) {
                    foundElse = true;
                }
                MinMax tmp = s.getOperation().apply(minMax, ValueExpressionVisitor.findMinMax(createdObjects, s.getValue(), lookup));
                minMaxBlock.min = Math.min(minMaxBlock.min, tmp.min);
                minMaxBlock.max = Math.max(minMaxBlock.max, tmp.max);
            }
            if (!foundElse) {
                minMaxBlock.min = Math.min(minMaxBlock.min, minMax.min);
                minMaxBlock.max = Math.max(minMaxBlock.max, minMax.max);
            }
        }
        minMax.min = minMaxBlock.min;
        minMax.max = minMaxBlock.max;
    }

    private static List<List<Statement>> splitIntoBlocks(List<Statement> statements) {
        ArrayList<List<Statement>> result = new ArrayList<List<Statement>>();
        ArrayList<Statement> block = null;
        for (Statement st : statements) {
            if (Statement.Keyword.IF.equals((Object)st.getKeyword())) {
                block = new ArrayList<Statement>();
                result.add(block);
            }
            if (block == null) {
                throw new IllegalArgumentException("Every block must start with an if-statement");
            }
            block.add(st);
        }
        return result;
    }
}

