/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.search;

import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public class KVStorage {
    private static final long EMPTY_POINTER = 0L;
    private static final long START_POINTER = 1L;
    static final int MAX_UNIQUE_KEYS = 16384;
    private static final int MAX_LENGTH = 255;
    private final Directory dir;
    private final DataAccess keys;
    private final DataAccess vals;
    private final Map<String, Integer> keyToIndex = new HashMap<String, Integer>();
    private final List<Class<?>> indexToClass = new ArrayList();
    private final List<String> indexToKey = new ArrayList<String>();
    private final BitUtil bitUtil = BitUtil.LITTLE;
    private long bytePointer = 1L;
    private long lastEntryPointer = -1L;
    private List<KeyValue> lastEntries;

    public KVStorage(Directory dir, boolean edge) {
        this.dir = dir;
        if (edge) {
            this.keys = dir.create("edgekv_keys", 10240);
            this.vals = dir.create("edgekv_vals");
        } else {
            this.keys = dir.create("nodekv_keys", 10240);
            this.vals = dir.create("nodekv_vals");
        }
    }

    public KVStorage create(long initBytes) {
        this.keys.create(initBytes);
        this.vals.create(initBytes);
        this.keyToIndex.put("", 0);
        this.indexToKey.add("");
        this.indexToClass.add(String.class);
        return this;
    }

    public boolean loadExisting() {
        if (this.vals.loadExisting()) {
            if (!this.keys.loadExisting()) {
                throw new IllegalStateException("Loaded values but cannot load keys");
            }
            this.bytePointer = this.bitUtil.toLong(this.vals.getHeader(0), this.vals.getHeader(4));
            GHUtility.checkDAVersion(this.vals.getName(), 2, this.vals.getHeader(8));
            GHUtility.checkDAVersion(this.keys.getName(), 2, this.keys.getHeader(0));
            int count = this.keys.getShort(0L);
            long keyBytePointer = 2L;
            for (int i = 0; i < count; ++i) {
                short keyLength = this.keys.getShort(keyBytePointer);
                byte[] keyBytes = new byte[keyLength];
                this.keys.getBytes(keyBytePointer += 2L, keyBytes, keyLength);
                String valueStr = new String(keyBytes, Helper.UTF_CS);
                keyBytePointer += (long)keyLength;
                this.keyToIndex.put(valueStr, this.keyToIndex.size());
                this.indexToKey.add(valueStr);
                int shortClassNameLength = 1;
                byte[] classBytes = new byte[shortClassNameLength];
                this.keys.getBytes(keyBytePointer, classBytes, shortClassNameLength);
                keyBytePointer += (long)shortClassNameLength;
                this.indexToClass.add(this.shortNameToClass(new String(classBytes, Helper.UTF_CS)));
            }
            return true;
        }
        return false;
    }

    Collection<String> getKeys() {
        return this.indexToKey;
    }

    private long setKVList(long currentPointer, List<KeyValue> entries) {
        if (currentPointer == 0L) {
            return currentPointer;
        }
        ++currentPointer;
        for (KeyValue entry : entries) {
            Class<?> clazz;
            String key = entry.key;
            if (key == null) {
                throw new IllegalArgumentException("key cannot be null");
            }
            Object value = entry.value;
            if (value == null) {
                throw new IllegalArgumentException("value for key " + key + " cannot be null");
            }
            if (!entry.fwd && !entry.bwd) {
                throw new IllegalArgumentException("Do not add KeyValue pair where fwd and bwd is false");
            }
            Integer keyIndex = this.keyToIndex.get(key);
            if (keyIndex == null) {
                keyIndex = this.keyToIndex.size();
                if (keyIndex >= 16384) {
                    throw new IllegalArgumentException("Cannot store more than 16384 unique keys");
                }
                this.keyToIndex.put(key, keyIndex);
                this.indexToKey.add(key);
                clazz = value.getClass();
                this.indexToClass.add(clazz);
            } else {
                clazz = this.indexToClass.get(keyIndex);
                if (clazz != value.getClass()) {
                    throw new IllegalArgumentException("Class of value for key " + key + " must be " + clazz.getSimpleName() + " but was " + value.getClass().getSimpleName());
                }
            }
            boolean hasDynLength = this.hasDynLength(clazz);
            if (hasDynLength && (clazz.equals(String.class) && ((String)value).isEmpty() || clazz.equals(byte[].class) && ((byte[])value).length == 0)) {
                this.vals.ensureCapacity(currentPointer + 3L);
                this.vals.setShort(currentPointer, keyIndex.shortValue());
                this.vals.setByte(currentPointer + 2L, (byte)0);
                currentPointer += 3L;
                continue;
            }
            byte[] valueBytes = this.getBytesForValue(clazz, value);
            this.vals.ensureCapacity(currentPointer + 2L + 1L + (long)valueBytes.length);
            this.vals.setShort(currentPointer, (short)(keyIndex << 2 | (entry.fwd ? 2 : 0) | (entry.bwd ? 1 : 0)));
            currentPointer += 2L;
            if (hasDynLength) {
                this.vals.setByte(currentPointer, (byte)valueBytes.length);
                ++currentPointer;
            }
            this.vals.setBytes(currentPointer, valueBytes, valueBytes.length);
            currentPointer += (long)valueBytes.length;
        }
        return currentPointer;
    }

    public long add(List<KeyValue> entries) {
        if (entries == null) {
            throw new IllegalArgumentException("specified List must not be null");
        }
        if (entries.isEmpty()) {
            return 0L;
        }
        if (entries.size() > 200) {
            throw new IllegalArgumentException("Cannot store more than 200 entries per entry");
        }
        if (this.isEquals(entries, this.lastEntries)) {
            return this.lastEntryPointer;
        }
        for (KeyValue kv : entries) {
            if (this.keyToIndex.get(kv.key) == null) continue;
            this.getBytesForValue(this.indexToClass.get(this.keyToIndex.get(kv.key)), kv.value);
        }
        this.lastEntries = entries;
        this.lastEntryPointer = this.bytePointer;
        this.vals.ensureCapacity(this.bytePointer + 1L);
        this.vals.setByte(this.bytePointer, (byte)entries.size());
        this.bytePointer = this.setKVList(this.bytePointer, entries);
        if (this.bytePointer < 0L) {
            throw new IllegalStateException("Negative bytePointer in KVStorage");
        }
        return this.lastEntryPointer;
    }

    private boolean isEquals(List<KeyValue> entries, List<KeyValue> lastEntries) {
        if (lastEntries != null && entries.size() == lastEntries.size()) {
            for (int i = 0; i < entries.size(); ++i) {
                KeyValue kv = entries.get(i);
                if (kv.value == null) {
                    throw new IllegalArgumentException("value for key " + kv.key + " cannot be null");
                }
                if (kv.equals(lastEntries.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<KeyValue> getAll(long entryPointer) {
        if (entryPointer < 0L) {
            throw new IllegalStateException("Pointer to access KVStorage cannot be negative:" + entryPointer);
        }
        if (entryPointer == 0L) {
            return Collections.emptyList();
        }
        int keyCount = this.vals.getByte(entryPointer) & 0xFF;
        if (keyCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyValue> list = new ArrayList<KeyValue>(keyCount);
        long tmpPointer = entryPointer + 1L;
        AtomicInteger sizeOfObject = new AtomicInteger();
        for (int i = 0; i < keyCount; ++i) {
            short currentKeyIndexRaw = this.vals.getShort(tmpPointer);
            boolean bwd = (currentKeyIndexRaw & 1) == 1;
            boolean fwd = (currentKeyIndexRaw & 2) == 2;
            int currentKeyIndex = currentKeyIndexRaw >>> 2;
            Object object = this.deserializeObj(sizeOfObject, tmpPointer += 2L, this.indexToClass.get(currentKeyIndex));
            tmpPointer += (long)sizeOfObject.get();
            String key = this.indexToKey.get(currentKeyIndex);
            list.add(new KeyValue(key, object, fwd, bwd));
        }
        return list;
    }

    public Map<String, Object> getMap(long entryPointer) {
        if (entryPointer < 0L) {
            throw new IllegalStateException("Pointer to access KVStorage cannot be negative:" + entryPointer);
        }
        if (entryPointer == 0L) {
            return Collections.emptyMap();
        }
        int keyCount = this.vals.getByte(entryPointer) & 0xFF;
        if (keyCount == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>(keyCount);
        long tmpPointer = entryPointer + 1L;
        AtomicInteger sizeOfObject = new AtomicInteger();
        for (int i = 0; i < keyCount; ++i) {
            short currentKeyIndexRaw = this.vals.getShort(tmpPointer);
            int currentKeyIndex = currentKeyIndexRaw >>> 2;
            Object object = this.deserializeObj(sizeOfObject, tmpPointer += 2L, this.indexToClass.get(currentKeyIndex));
            tmpPointer += (long)sizeOfObject.get();
            String key = this.indexToKey.get(currentKeyIndex);
            map.put(key, object);
        }
        return map;
    }

    private boolean hasDynLength(Class<?> clazz) {
        return clazz.equals(String.class) || clazz.equals(byte[].class);
    }

    private int getFixLength(Class<?> clazz) {
        if (clazz.equals(Integer.class) || clazz.equals(Float.class)) {
            return 4;
        }
        if (clazz.equals(Long.class) || clazz.equals(Double.class)) {
            return 8;
        }
        throw new IllegalArgumentException("unknown class " + clazz);
    }

    private byte[] getBytesForValue(Class<?> clazz, Object value) {
        byte[] bytes;
        if (clazz.equals(String.class)) {
            bytes = ((String)value).getBytes(Helper.UTF_CS);
            if (bytes.length > 255) {
                throw new IllegalArgumentException("bytes.length cannot be > 255 but was " + bytes.length + ". String:" + value);
            }
        } else if (clazz.equals(byte[].class)) {
            bytes = (byte[])value;
            if (bytes.length > 255) {
                throw new IllegalArgumentException("bytes.length cannot be > 255 but was " + bytes.length);
            }
        } else {
            if (clazz.equals(Integer.class)) {
                return this.bitUtil.fromInt((Integer)value);
            }
            if (clazz.equals(Long.class)) {
                return this.bitUtil.fromLong((Long)value);
            }
            if (clazz.equals(Float.class)) {
                return this.bitUtil.fromFloat(((Float)value).floatValue());
            }
            if (clazz.equals(Double.class)) {
                return this.bitUtil.fromDouble((Double)value);
            }
            throw new IllegalArgumentException("The Class of a value was " + clazz.getSimpleName() + ", currently supported: byte[], String, int, long, float and double");
        }
        return bytes;
    }

    private String classToShortName(Class<?> clazz) {
        if (clazz.equals(String.class)) {
            return "S";
        }
        if (clazz.equals(Integer.class)) {
            return "i";
        }
        if (clazz.equals(Long.class)) {
            return "l";
        }
        if (clazz.equals(Float.class)) {
            return "f";
        }
        if (clazz.equals(Double.class)) {
            return "d";
        }
        if (clazz.equals(byte[].class)) {
            return "[";
        }
        throw new IllegalArgumentException("Cannot find short name. Unknown class " + clazz);
    }

    private Class<?> shortNameToClass(String name) {
        if (name.equals("S")) {
            return String.class;
        }
        if (name.equals("i")) {
            return Integer.class;
        }
        if (name.equals("l")) {
            return Long.class;
        }
        if (name.equals("f")) {
            return Float.class;
        }
        if (name.equals("d")) {
            return Double.class;
        }
        if (name.equals("[")) {
            return byte[].class;
        }
        throw new IllegalArgumentException("Cannot find class. Unknown short name " + name);
    }

    private Object deserializeObj(AtomicInteger sizeOfObject, long pointer, Class<?> clazz) {
        if (this.hasDynLength(clazz)) {
            int valueLength = this.vals.getByte(pointer) & 0xFF;
            byte[] valueBytes = new byte[valueLength];
            this.vals.getBytes(++pointer, valueBytes, valueBytes.length);
            if (sizeOfObject != null) {
                sizeOfObject.set(1 + valueLength);
            }
            if (clazz.equals(String.class)) {
                return new String(valueBytes, Helper.UTF_CS);
            }
            if (clazz.equals(byte[].class)) {
                return valueBytes;
            }
            throw new IllegalArgumentException();
        }
        byte[] valueBytes = new byte[this.getFixLength(clazz)];
        this.vals.getBytes(pointer, valueBytes, valueBytes.length);
        if (clazz.equals(Integer.class)) {
            if (sizeOfObject != null) {
                sizeOfObject.set(4);
            }
            return this.bitUtil.toInt(valueBytes, 0);
        }
        if (clazz.equals(Long.class)) {
            if (sizeOfObject != null) {
                sizeOfObject.set(8);
            }
            return this.bitUtil.toLong(valueBytes, 0);
        }
        if (clazz.equals(Float.class)) {
            if (sizeOfObject != null) {
                sizeOfObject.set(4);
            }
            return Float.valueOf(this.bitUtil.toFloat(valueBytes, 0));
        }
        if (clazz.equals(Double.class)) {
            if (sizeOfObject != null) {
                sizeOfObject.set(8);
            }
            return this.bitUtil.toDouble(valueBytes, 0);
        }
        throw new IllegalArgumentException("unknown class " + clazz);
    }

    public Object get(long entryPointer, String key, boolean reverse) {
        if (entryPointer < 0L) {
            throw new IllegalStateException("Pointer to access KVStorage cannot be negative:" + entryPointer);
        }
        if (entryPointer == 0L) {
            return null;
        }
        Integer keyIndex = this.keyToIndex.get(key);
        if (keyIndex == null) {
            return null;
        }
        int keyCount = this.vals.getByte(entryPointer) & 0xFF;
        if (keyCount == 0) {
            return null;
        }
        long tmpPointer = entryPointer + 1L;
        for (int i = 0; i < keyCount; ++i) {
            short currentKeyIndexRaw = this.vals.getShort(tmpPointer);
            boolean bwd = (currentKeyIndexRaw & 1) == 1;
            boolean fwd = (currentKeyIndexRaw & 2) == 2;
            int currentKeyIndex = currentKeyIndexRaw >>> 2;
            assert (currentKeyIndex < this.indexToKey.size()) : "invalid key index " + currentKeyIndex + ">=" + this.indexToKey.size() + ", entryPointer=" + entryPointer + ", max=" + this.bytePointer;
            tmpPointer += 2L;
            if ((!reverse && fwd || reverse && bwd) && currentKeyIndex == keyIndex) {
                return this.deserializeObj(null, tmpPointer, this.indexToClass.get(keyIndex));
            }
            Class<?> clazz = this.indexToClass.get(currentKeyIndex);
            int valueLength = this.hasDynLength(clazz) ? 1 + this.vals.getByte(tmpPointer) & 0xFF : this.getFixLength(clazz);
            tmpPointer += (long)valueLength;
        }
        return null;
    }

    public void flush() {
        this.keys.ensureCapacity(2L);
        this.keys.setShort(0L, (short)this.keyToIndex.size());
        long keyBytePointer = 2L;
        for (int i = 0; i < this.indexToKey.size(); ++i) {
            String key = this.indexToKey.get(i);
            byte[] keyBytes = this.getBytesForValue(String.class, key);
            this.keys.ensureCapacity(keyBytePointer + 2L + (long)keyBytes.length);
            this.keys.setShort(keyBytePointer, (short)keyBytes.length);
            this.keys.setBytes(keyBytePointer += 2L, keyBytes, keyBytes.length);
            keyBytePointer += (long)keyBytes.length;
            Class<?> clazz = this.indexToClass.get(i);
            byte[] clazzBytes = this.getBytesForValue(String.class, this.classToShortName(clazz));
            if (clazzBytes.length != 1) {
                throw new IllegalArgumentException("class name byte length must be 1 but was " + clazzBytes.length);
            }
            this.keys.ensureCapacity(keyBytePointer + 1L);
            this.keys.setBytes(keyBytePointer, clazzBytes, 1);
            ++keyBytePointer;
        }
        this.keys.setHeader(0, 2);
        this.keys.flush();
        this.vals.setHeader(0, this.bitUtil.getIntLow(this.bytePointer));
        this.vals.setHeader(4, this.bitUtil.getIntHigh(this.bytePointer));
        this.vals.setHeader(8, 2);
        this.vals.flush();
    }

    public void clear() {
        this.dir.remove(this.keys.getName());
        this.dir.remove(this.vals.getName());
    }

    public void close() {
        this.keys.close();
        this.vals.close();
    }

    public boolean isClosed() {
        return this.vals.isClosed() && this.keys.isClosed();
    }

    public long getCapacity() {
        return this.vals.getCapacity() + this.keys.getCapacity();
    }

    public static String cutString(String value) {
        byte[] bytes = value.getBytes(Helper.UTF_CS);
        return bytes.length > 250 ? new String(bytes, 0, 250, Helper.UTF_CS) : value;
    }

    public static class KeyValue {
        public static final String STREET_NAME = "street_name";
        public static final String STREET_REF = "street_ref";
        public static final String STREET_DESTINATION = "street_destination";
        public static final String STREET_DESTINATION_REF = "street_destination_ref";
        public String key;
        public Object value;
        public boolean fwd;
        public boolean bwd;

        public KeyValue(String key, Object value) {
            this.key = key;
            this.value = value;
            this.fwd = true;
            this.bwd = true;
        }

        public Object getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public KeyValue(String key, Object value, boolean fwd, boolean bwd) {
            this.key = key;
            this.value = value;
            this.fwd = fwd;
            this.bwd = bwd;
        }

        public static List<KeyValue> createKV(String key, Object value) {
            return Collections.singletonList(new KeyValue(key, value));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyValue keyValue = (KeyValue)o;
            return this.key.equals(keyValue.key) && this.fwd == keyValue.fwd && this.bwd == keyValue.bwd && (this.value instanceof byte[] && keyValue.value instanceof byte[] && Arrays.equals((byte[])this.value, (byte[])keyValue.value) || this.value.equals(keyValue.value));
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value, this.fwd, this.bwd);
        }

        public String toString() {
            return this.key + '=' + this.value + " (" + this.fwd + "|" + this.bwd + ")";
        }
    }
}

