/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.PointList;

public class ExtendedNodeAccess
implements NodeAccess {
    private final NodeAccess nodeAccess;
    private final PointList additionalNodes;
    private final int firstAdditionalNodeId;

    public ExtendedNodeAccess(NodeAccess nodeAccess, PointList additionalNodes, int firstAdditionalNodeId) {
        this.nodeAccess = nodeAccess;
        this.firstAdditionalNodeId = firstAdditionalNodeId;
        this.additionalNodes = additionalNodes;
    }

    public void ensureNode(int nodeId) {
        this.nodeAccess.ensureNode(nodeId);
    }

    public boolean is3D() {
        return this.nodeAccess.is3D();
    }

    public int getDimension() {
        return this.nodeAccess.getDimension();
    }

    public double getLat(int nodeId) {
        if (this.isAdditionalNode(nodeId)) {
            return this.additionalNodes.getLat(nodeId - this.firstAdditionalNodeId);
        }
        return this.nodeAccess.getLat(nodeId);
    }

    public double getLon(int nodeId) {
        if (this.isAdditionalNode(nodeId)) {
            return this.additionalNodes.getLon(nodeId - this.firstAdditionalNodeId);
        }
        return this.nodeAccess.getLon(nodeId);
    }

    public double getEle(int nodeId) {
        if (this.isAdditionalNode(nodeId)) {
            return this.additionalNodes.getEle(nodeId - this.firstAdditionalNodeId);
        }
        return this.nodeAccess.getEle(nodeId);
    }

    @Override
    public int getTurnCostIndex(int nodeId) {
        if (this.isAdditionalNode(nodeId)) {
            return 0;
        }
        return this.nodeAccess.getTurnCostIndex(nodeId);
    }

    public void setNode(int nodeId, double lat, double lon, double ele) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTurnCostIndex(int nodeId, int additionalValue) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private boolean isAdditionalNode(int nodeId) {
        return nodeId >= this.firstAdditionalNodeId;
    }
}

