/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.PointList;

public class RamerDouglasPeucker {
    private double normedMaxDist;
    private double elevationMaxDistance;
    private double maxDistance;
    private DistanceCalc calc;
    private boolean approx;

    public RamerDouglasPeucker() {
        this.setApproximation(true);
        this.setMaxDistance(1.0);
        this.setElevationMaxDistance(Double.MAX_VALUE);
    }

    public void setApproximation(boolean a) {
        this.approx = a;
        this.calc = this.approx ? DistancePlaneProjection.DIST_PLANE : DistanceCalcEarth.DIST_EARTH;
    }

    public RamerDouglasPeucker setMaxDistance(double dist) {
        this.normedMaxDist = this.calc.calcNormalizedDist(dist);
        this.maxDistance = dist;
        return this;
    }

    public RamerDouglasPeucker setElevationMaxDistance(double dist) {
        this.elevationMaxDistance = dist;
        return this;
    }

    public int simplify(PointList points) {
        return this.simplify(points, 0, points.size() - 1);
    }

    public int simplify(PointList points, int fromIndex, int lastIndex) {
        return this.simplify(points, fromIndex, lastIndex, true);
    }

    public int simplify(PointList points, int fromIndex, int lastIndex, boolean compress) {
        int removed = 0;
        int size = lastIndex - fromIndex;
        if (this.approx) {
            int delta = 500;
            int segments = size / delta + 1;
            int start = fromIndex;
            for (int i = 0; i < segments; ++i) {
                removed += this.subSimplify(points, start, Math.min(lastIndex, start + delta));
                start += delta;
            }
        } else {
            removed = this.subSimplify(points, fromIndex, lastIndex);
        }
        if (removed > 0 && compress) {
            RamerDouglasPeucker.removeNaN(points);
        }
        return removed;
    }

    int subSimplify(PointList points, int fromIndex, int lastIndex) {
        if (lastIndex - fromIndex < 2) {
            return 0;
        }
        int indexWithMaxDist = -1;
        double maxDist = -1.0;
        double elevationFactor = this.maxDistance / this.elevationMaxDistance;
        double firstLat = points.getLat(fromIndex);
        double firstLon = points.getLon(fromIndex);
        double firstEle = points.getEle(fromIndex);
        double lastLat = points.getLat(lastIndex);
        double lastLon = points.getLon(lastIndex);
        double lastEle = points.getEle(lastIndex);
        for (int i = fromIndex + 1; i < lastIndex; ++i) {
            double dist;
            double lat = points.getLat(i);
            if (Double.isNaN(lat)) continue;
            double lon = points.getLon(i);
            double ele = points.getEle(i);
            double d = dist = points.is3D() && this.elevationMaxDistance < Double.MAX_VALUE && !Double.isNaN(firstEle) && !Double.isNaN(lastEle) && !Double.isNaN(ele) ? this.calc.calcNormalizedEdgeDistance3D(lat, lon, ele * elevationFactor, firstLat, firstLon, firstEle * elevationFactor, lastLat, lastLon, lastEle * elevationFactor) : this.calc.calcNormalizedEdgeDistance(lat, lon, firstLat, firstLon, lastLat, lastLon);
            if (!(maxDist < dist)) continue;
            indexWithMaxDist = i;
            maxDist = dist;
        }
        if (indexWithMaxDist < 0) {
            throw new IllegalStateException("maximum not found in [" + fromIndex + "," + lastIndex + "]");
        }
        int counter = 0;
        if (maxDist < this.normedMaxDist) {
            for (int i = fromIndex + 1; i < lastIndex; ++i) {
                points.set(i, Double.NaN, Double.NaN, Double.NaN);
                ++counter;
            }
        } else {
            counter = this.subSimplify(points, fromIndex, indexWithMaxDist);
            counter += this.subSimplify(points, indexWithMaxDist, lastIndex);
        }
        return counter;
    }

    static void removeNaN(PointList pointList) {
        int curr = 0;
        for (int i = 0; i < pointList.size(); ++i) {
            if (Double.isNaN(pointList.getLat(i))) continue;
            pointList.set(curr, pointList.getLat(i), pointList.getLon(i), pointList.getEle(i));
            ++curr;
        }
        pointList.trimToSize(curr);
    }
}

