/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Helper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.LongConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzipper {
    public void unzip(String from, boolean remove) throws IOException {
        String to = Helper.pruneFileEnd((String)from);
        this.unzip(from, to, remove);
    }

    public boolean unzip(String fromStr, String toStr, boolean remove) throws IOException {
        File from = new File(fromStr);
        if (!from.exists() || fromStr.equals(toStr)) {
            return false;
        }
        this.unzip(new FileInputStream(from), new File(toStr), null);
        if (remove) {
            Helper.removeDir((File)from);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unzip(InputStream fromIs, File toFolder, LongConsumer progressListener) throws IOException {
        if (!toFolder.exists()) {
            toFolder.mkdirs();
        }
        long sumBytes = 0L;
        try (ZipInputStream zis = new ZipInputStream(fromIs);){
            ZipEntry ze = zis.getNextEntry();
            byte[] buffer = new byte[8192];
            while (ze != null) {
                if (ze.isDirectory()) {
                    this.getVerifiedFile(toFolder, ze).mkdir();
                } else {
                    double factor = 1.0;
                    if (ze.getCompressedSize() > 0L && ze.getSize() > 0L) {
                        factor = (double)ze.getCompressedSize() / (double)ze.getSize();
                    }
                    File newFile = this.getVerifiedFile(toFolder, ze);
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                            sumBytes = (long)((double)sumBytes + (double)len * factor);
                            if (progressListener == null) continue;
                            progressListener.accept(sumBytes);
                        }
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    File getVerifiedFile(File destinationDir, ZipEntry ze) throws IOException {
        File destinationFile = new File(destinationDir, ze.getName());
        if (!destinationFile.getCanonicalPath().startsWith(destinationDir.getCanonicalPath() + File.separator)) {
            throw new SecurityException("Zip Entry is outside of the target dir: " + ze.getName());
        }
        return destinationFile;
    }
}

