/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.bmw.hmm.SequenceState;
import com.bmw.hmm.ViterbiAlgorithm;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.HmmProbabilities;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.State;
import com.graphhopper.matching.TimeStep;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.DijkstraBidirectionRef;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.lm.LMApproximator;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.routing.util.DefaultEdgeFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.FlagEncoder;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.WeightApproximator;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapMatching {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final double uTurnDistancePenalty;
    private final Graph graph;
    private final PrepareLandmarks landmarks;
    private final LocationIndexTree locationIndex;
    private double measurementErrorSigma = 50.0;
    private double transitionProbabilityBeta = 2.0;
    private final int maxVisitedNodes;
    private final DistanceCalc distanceCalc = new DistancePlaneProjection();
    private final Weighting weighting;
    private QueryGraph queryGraph;

    public MapMatching(GraphHopper graphHopper, PMap hints) {
        boolean useDijkstra;
        this.locationIndex = (LocationIndexTree)graphHopper.getLocationIndex();
        if (hints.has("vehicle")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a vehicle, use the profile parameter instead, see core/#1958");
        }
        if (hints.has("weighting")) {
            throw new IllegalArgumentException("MapMatching hints may no longer contain a weighting, use the profile parameter instead, see core/#1958");
        }
        if (graphHopper.getProfiles().isEmpty()) {
            throw new IllegalArgumentException("No profiles found, you need to configure at least one profile to use map matching");
        }
        if (!hints.has("profile")) {
            throw new IllegalArgumentException("You need to specify a profile to perform map matching");
        }
        String profileStr = hints.getString("profile", "");
        Profile profile = graphHopper.getProfile(profileStr);
        if (profile == null) {
            List profiles = graphHopper.getProfiles();
            ArrayList<String> profileNames = new ArrayList<String>(profiles.size());
            for (Profile p : profiles) {
                profileNames.add(p.getName());
            }
            throw new IllegalArgumentException("Could not find profile '" + profileStr + "', choose one of: " + profileNames);
        }
        double PENALTY_CONVERSION_VELOCITY = 5.0;
        double headingTimePenalty = hints.getDouble("heading_penalty", 300.0);
        this.uTurnDistancePenalty = headingTimePenalty * 5.0;
        boolean disableLM = hints.getBool("lm.disable", false);
        if (graphHopper.getLMPreparationHandler().isEnabled() && disableLM && !graphHopper.getRouterConfig().isLMDisablingAllowed()) {
            throw new IllegalArgumentException("Disabling LM is not allowed");
        }
        boolean disableCH = hints.getBool("ch.disable", false);
        if (graphHopper.getCHPreparationHandler().isEnabled() && disableCH && !graphHopper.getRouterConfig().isCHDisablingAllowed()) {
            throw new IllegalArgumentException("Disabling CH is not allowed");
        }
        boolean bl = useDijkstra = disableLM || disableCH;
        if (graphHopper.getLMPreparationHandler().isEnabled() && !useDijkstra) {
            ArrayList<String> lmProfileNames = new ArrayList<String>();
            PrepareLandmarks lmPreparation = null;
            for (LMProfile lmProfile : graphHopper.getLMPreparationHandler().getLMProfiles()) {
                lmProfileNames.add(lmProfile.getProfile());
                if (!lmProfile.getProfile().equals(profile.getName())) continue;
                lmPreparation = graphHopper.getLMPreparationHandler().getPreparation(lmProfile.usesOtherPreparation() ? lmProfile.getPreparationProfile() : lmProfile.getProfile());
            }
            if (lmPreparation == null) {
                throw new IllegalArgumentException("Cannot find LM preparation for the requested profile: '" + profile.getName() + "'\nYou can try disabling LM using " + "lm.disable" + "=true\navailable LM profiles: " + lmProfileNames);
            }
            this.landmarks = lmPreparation;
        } else {
            this.landmarks = null;
        }
        this.graph = graphHopper.getGraphHopperStorage();
        this.weighting = graphHopper.createWeighting(profile, hints, true);
        this.maxVisitedNodes = hints.getInt("max_visited_nodes", Integer.MAX_VALUE);
    }

    public void setTransitionProbabilityBeta(double transitionProbabilityBeta) {
        this.transitionProbabilityBeta = transitionProbabilityBeta;
    }

    public void setMeasurementErrorSigma(double measurementErrorSigma) {
        this.measurementErrorSigma = measurementErrorSigma;
    }

    public MatchResult match(List<Observation> observations) {
        List<Observation> filteredObservations = this.filterObservations(observations);
        List<Collection<Snap>> splitsPerObservation = filteredObservations.stream().map(o -> this.locationIndex.findNClosest(o.getPoint().lat, o.getPoint().lon, (EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)this.weighting.getFlagEncoder()), this.measurementErrorSigma)).collect(Collectors.toList());
        this.queryGraph = QueryGraph.create((Graph)this.graph, splitsPerObservation.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        splitsPerObservation = splitsPerObservation.stream().map(this::deduplicate).collect(Collectors.toList());
        List<TimeStep<State, Observation, Path>> timeSteps = this.createTimeSteps(filteredObservations, splitsPerObservation, this.queryGraph);
        List<SequenceState<State, Observation, Path>> seq = this.computeViterbiSequence(timeSteps, observations.size(), this.queryGraph);
        Map<String, EdgeIteratorState> virtualEdgesMap = this.createVirtualEdgesMap(splitsPerObservation);
        List<EdgeIteratorState> path = seq.stream().filter(s1 -> s1.transitionDescriptor != null).flatMap(s1 -> ((Path)s1.transitionDescriptor).calcEdges().stream()).collect(Collectors.toList());
        MatchResult result = new MatchResult(this.prepareEdgeMatches(seq, virtualEdgesMap));
        result.setMergedPath(new MapMatchedPath((Graph)this.queryGraph, this.weighting, path));
        result.setMatchMillis(seq.stream().filter(s -> s.transitionDescriptor != null).mapToLong(s -> ((Path)s.transitionDescriptor).getTime()).sum());
        result.setMatchLength(seq.stream().filter(s -> s.transitionDescriptor != null).mapToDouble(s -> ((Path)s.transitionDescriptor).getDistance()).sum());
        result.setGPXEntriesLength(this.gpxLength(observations));
        result.setGraph((Graph)this.queryGraph);
        result.setWeighting(this.weighting);
        return result;
    }

    private List<Observation> filterObservations(List<Observation> observations) {
        ArrayList<Observation> filtered = new ArrayList<Observation>();
        Observation prevEntry = null;
        int last = observations.size() - 1;
        for (int i = 0; i <= last; ++i) {
            Observation observation = observations.get(i);
            if (i == 0 || i == last || this.distanceCalc.calcDist(prevEntry.getPoint().getLat(), prevEntry.getPoint().getLon(), observation.getPoint().getLat(), observation.getPoint().getLon()) > 2.0 * this.measurementErrorSigma) {
                filtered.add(observation);
                prevEntry = observation;
                continue;
            }
            this.logger.debug("Filter out observation: {}", (Object)(i + 1));
        }
        return filtered;
    }

    private Collection<Snap> deduplicate(Collection<Snap> splits) {
        Map<Integer, Snap> splitsByNodeNumber = splits.stream().collect(Collectors.toMap(Snap::getClosestNode, s -> s, (s1, s2) -> s2));
        return splitsByNodeNumber.values();
    }

    private List<TimeStep<State, Observation, Path>> createTimeSteps(List<Observation> filteredObservations, List<Collection<Snap>> splitsPerObservation, QueryGraph queryGraph) {
        if (splitsPerObservation.size() != filteredObservations.size()) {
            throw new IllegalArgumentException("filteredGPXEntries and queriesPerEntry must have same size.");
        }
        ArrayList<TimeStep<State, Observation, Path>> timeSteps = new ArrayList<TimeStep<State, Observation, Path>>();
        for (int i = 0; i < filteredObservations.size(); ++i) {
            Observation observation = filteredObservations.get(i);
            Collection<Snap> splits = splitsPerObservation.get(i);
            ArrayList<State> candidates = new ArrayList<State>();
            for (Snap split : splits) {
                if (queryGraph.isVirtualNode(split.getClosestNode())) {
                    ArrayList<VirtualEdgeIteratorState> virtualEdges = new ArrayList<VirtualEdgeIteratorState>();
                    EdgeIterator iter = queryGraph.createEdgeExplorer().setBaseNode(split.getClosestNode());
                    while (iter.next()) {
                        if (!queryGraph.isVirtualEdge(iter.getEdge())) {
                            throw new RuntimeException("Virtual nodes must only have virtual edges to adjacent nodes.");
                        }
                        virtualEdges.add((VirtualEdgeIteratorState)queryGraph.getEdgeIteratorState(iter.getEdge(), iter.getAdjNode()));
                    }
                    if (virtualEdges.size() != 2) {
                        throw new RuntimeException("Each virtual node must have exactly 2 virtual edges (reverse virtual edges are not returned by the EdgeIterator");
                    }
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(0), (VirtualEdgeIteratorState)virtualEdges.get(1)));
                    candidates.add(new State(observation, split, (VirtualEdgeIteratorState)virtualEdges.get(1), (VirtualEdgeIteratorState)virtualEdges.get(0)));
                    continue;
                }
                candidates.add(new State(observation, split));
            }
            timeSteps.add(new TimeStep(observation, candidates));
        }
        return timeSteps;
    }

    private List<SequenceState<State, Observation, Path>> computeViterbiSequence(List<TimeStep<State, Observation, Path>> timeSteps, int originalGpxEntriesCount, QueryGraph queryGraph) {
        HmmProbabilities probabilities = new HmmProbabilities(this.measurementErrorSigma, this.transitionProbabilityBeta);
        ViterbiAlgorithm viterbi = new ViterbiAlgorithm();
        this.logger.debug("\n=============== Paths ===============");
        int timeStepCounter = 0;
        TimeStep<State, Observation, Path> prevTimeStep = null;
        int i = 1;
        for (TimeStep<State, Observation, Path> timeStep : timeSteps) {
            this.logger.debug("\nPaths to time step {}", (Object)i++);
            this.computeEmissionProbabilities(timeStep, probabilities);
            if (prevTimeStep == null) {
                viterbi.startWithInitialObservation(timeStep.observation, timeStep.candidates, timeStep.emissionLogProbabilities);
            } else {
                this.computeTransitionProbabilities(prevTimeStep, timeStep, probabilities, queryGraph);
                viterbi.nextStep(timeStep.observation, timeStep.candidates, timeStep.emissionLogProbabilities, timeStep.transitionLogProbabilities, timeStep.roadPaths);
            }
            if (viterbi.isBroken()) {
                double dist;
                String likelyReasonStr = "";
                if (prevTimeStep != null && (dist = this.distanceCalc.calcDist(((Observation)prevTimeStep.observation).getPoint().lat, ((Observation)prevTimeStep.observation).getPoint().lon, ((Observation)timeStep.observation).getPoint().lat, ((Observation)timeStep.observation).getPoint().lon)) > 2000.0) {
                    likelyReasonStr = "Too long distance to previous measurement? " + Math.round(dist) + "m, ";
                }
                throw new IllegalArgumentException("Sequence is broken for submitted track at time step " + timeStepCounter + " (" + originalGpxEntriesCount + " points). " + likelyReasonStr + "observation:" + timeStep.observation + ", " + timeStep.candidates.size() + " candidates: " + this.getSnappedCandidates(timeStep.candidates) + ". If a match is expected consider increasing max_visited_nodes.");
            }
            ++timeStepCounter;
            prevTimeStep = timeStep;
        }
        return viterbi.computeMostLikelySequence();
    }

    private void computeEmissionProbabilities(TimeStep<State, Observation, Path> timeStep, HmmProbabilities probabilities) {
        for (State candidate : timeStep.candidates) {
            double distance = candidate.getSnap().getQueryDistance();
            timeStep.addEmissionLogProbability(candidate, probabilities.emissionLogProbability(distance));
        }
    }

    private void computeTransitionProbabilities(TimeStep<State, Observation, Path> prevTimeStep, TimeStep<State, Observation, Path> timeStep, HmmProbabilities probabilities, QueryGraph queryGraph) {
        double linearDistance = this.distanceCalc.calcDist(((Observation)prevTimeStep.observation).getPoint().lat, ((Observation)prevTimeStep.observation).getPoint().lon, ((Observation)timeStep.observation).getPoint().lat, ((Observation)timeStep.observation).getPoint().lon);
        for (State from : prevTimeStep.candidates) {
            for (State to : timeStep.candidates) {
                Object router;
                if (from.isOnDirectedEdge()) {
                    queryGraph.unfavorVirtualEdge(from.getIncomingVirtualEdge().getEdge());
                }
                if (to.isOnDirectedEdge()) {
                    queryGraph.unfavorVirtualEdge(to.getOutgoingVirtualEdge().getEdge());
                }
                if (this.landmarks != null) {
                    AStarBidirection algo = new AStarBidirection((Graph)queryGraph, this.weighting, TraversalMode.NODE_BASED){

                        protected void initCollections(int size) {
                            super.initCollections(50);
                        }
                    };
                    LandmarkStorage lms = this.landmarks.getLandmarkStorage();
                    int activeLM = Math.min(8, lms.getLandmarkCount());
                    algo.setApproximation((WeightApproximator)LMApproximator.forLandmarks((Graph)queryGraph, (LandmarkStorage)lms, (int)activeLM));
                    router = algo;
                } else {
                    router = new DijkstraBidirectionRef((Graph)queryGraph, this.weighting, TraversalMode.NODE_BASED){

                        protected void initCollections(int size) {
                            super.initCollections(50);
                        }
                    };
                }
                router.setMaxVisitedNodes(this.maxVisitedNodes);
                Path path = router.calcPath(from.getSnap().getClosestNode(), to.getSnap().getClosestNode());
                if (path.isFound()) {
                    timeStep.addRoadPath(from, to, path);
                    double penalizedPathDistance = this.penalizedPathDistance(path, queryGraph.getUnfavoredVirtualEdges());
                    this.logger.debug("Path from: {}, to: {}, penalized path length: {}", new Object[]{from, to, penalizedPathDistance});
                    double transitionLogProbability = probabilities.transitionLogProbability(penalizedPathDistance, linearDistance);
                    timeStep.addTransitionLogProbability(from, to, transitionLogProbability);
                } else {
                    this.logger.debug("No path found for from: {}, to: {}", (Object)from, (Object)to);
                }
                queryGraph.clearUnfavoredStatus();
            }
        }
    }

    private double penalizedPathDistance(Path path, Set<EdgeIteratorState> penalizedVirtualEdges) {
        double totalPenalty = 0.0;
        List edges = path.calcEdges();
        if (!edges.isEmpty() && penalizedVirtualEdges.contains(edges.get(0))) {
            totalPenalty += this.uTurnDistancePenalty;
        }
        if (edges.size() > 1 && penalizedVirtualEdges.contains(edges.get(edges.size() - 1))) {
            totalPenalty += this.uTurnDistancePenalty;
        }
        return path.getDistance() + totalPenalty;
    }

    private List<EdgeMatch> prepareEdgeMatches(List<SequenceState<State, Observation, Path>> seq, Map<String, EdgeIteratorState> virtualEdgesMap) {
        ArrayList<EdgeMatch> edgeMatches = new ArrayList<EdgeMatch>();
        ArrayList<State> states = new ArrayList<State>();
        EdgeIteratorState currentDirectedRealEdge = null;
        for (SequenceState<State, Observation, Path> transitionAndState : seq) {
            if (transitionAndState.transitionDescriptor != null) {
                for (EdgeIteratorState edge : ((Path)transitionAndState.transitionDescriptor).calcEdges()) {
                    EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(virtualEdgesMap, edge);
                    if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                        EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                        edgeMatches.add(edgeMatch);
                        states = new ArrayList();
                    }
                    currentDirectedRealEdge = newDirectedRealEdge;
                }
            }
            if (((State)transitionAndState.state).isOnDirectedEdge()) {
                EdgeIteratorState newDirectedRealEdge = this.resolveToRealEdge(virtualEdgesMap, ((State)transitionAndState.state).getOutgoingVirtualEdge());
                if (currentDirectedRealEdge != null && !this.equalEdges(currentDirectedRealEdge, newDirectedRealEdge)) {
                    EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
                    edgeMatches.add(edgeMatch);
                    states = new ArrayList();
                }
                currentDirectedRealEdge = newDirectedRealEdge;
            }
            states.add((State)transitionAndState.state);
        }
        if (currentDirectedRealEdge != null) {
            EdgeMatch edgeMatch = new EdgeMatch(currentDirectedRealEdge, states);
            edgeMatches.add(edgeMatch);
        }
        return edgeMatches;
    }

    private double gpxLength(List<Observation> gpxList) {
        if (gpxList.isEmpty()) {
            return 0.0;
        }
        double gpxLength = 0.0;
        Observation prevEntry = gpxList.get(0);
        for (int i = 1; i < gpxList.size(); ++i) {
            Observation entry = gpxList.get(i);
            gpxLength += this.distanceCalc.calcDist(prevEntry.getPoint().lat, prevEntry.getPoint().lon, entry.getPoint().lat, entry.getPoint().lon);
            prevEntry = entry;
        }
        return gpxLength;
    }

    private boolean equalEdges(EdgeIteratorState edge1, EdgeIteratorState edge2) {
        return edge1.getEdge() == edge2.getEdge() && edge1.getBaseNode() == edge2.getBaseNode() && edge1.getAdjNode() == edge2.getAdjNode();
    }

    private EdgeIteratorState resolveToRealEdge(Map<String, EdgeIteratorState> virtualEdgesMap, EdgeIteratorState edgeIteratorState) {
        if (this.queryGraph.isVirtualNode(edgeIteratorState.getBaseNode()) || this.queryGraph.isVirtualNode(edgeIteratorState.getAdjNode())) {
            return virtualEdgesMap.get(this.virtualEdgesMapKey(edgeIteratorState));
        }
        return edgeIteratorState;
    }

    private Map<String, EdgeIteratorState> createVirtualEdgesMap(List<Collection<Snap>> queriesPerEntry) {
        EdgeExplorer explorer = this.queryGraph.createEdgeExplorer((EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)this.weighting.getFlagEncoder()));
        HashMap<String, EdgeIteratorState> virtualEdgesMap = new HashMap<String, EdgeIteratorState>();
        for (Collection<Snap> snaps : queriesPerEntry) {
            for (Snap snap : snaps) {
                if (!this.queryGraph.isVirtualNode(snap.getClosestNode())) continue;
                EdgeIterator iter = explorer.setBaseNode(snap.getClosestNode());
                while (iter.next()) {
                    int node = this.traverseToClosestRealAdj((EdgeIteratorState)iter);
                    if (node == snap.getClosestEdge().getAdjNode()) {
                        virtualEdgesMap.put(this.virtualEdgesMapKey((EdgeIteratorState)iter), snap.getClosestEdge().detach(false));
                        virtualEdgesMap.put(this.reverseVirtualEdgesMapKey((EdgeIteratorState)iter), snap.getClosestEdge().detach(true));
                        continue;
                    }
                    if (node == snap.getClosestEdge().getBaseNode()) {
                        virtualEdgesMap.put(this.virtualEdgesMapKey((EdgeIteratorState)iter), snap.getClosestEdge().detach(true));
                        virtualEdgesMap.put(this.reverseVirtualEdgesMapKey((EdgeIteratorState)iter), snap.getClosestEdge().detach(false));
                        continue;
                    }
                    throw new RuntimeException();
                }
            }
        }
        return virtualEdgesMap;
    }

    private String virtualEdgesMapKey(EdgeIteratorState iter) {
        return iter.getBaseNode() + "-" + iter.getEdge() + "-" + iter.getAdjNode();
    }

    private String reverseVirtualEdgesMapKey(EdgeIteratorState iter) {
        return iter.getAdjNode() + "-" + iter.getEdge() + "-" + iter.getBaseNode();
    }

    private int traverseToClosestRealAdj(EdgeIteratorState edge) {
        if (!this.queryGraph.isVirtualNode(edge.getAdjNode())) {
            return edge.getAdjNode();
        }
        EdgeExplorer explorer = this.queryGraph.createEdgeExplorer((EdgeFilter)DefaultEdgeFilter.allEdges((FlagEncoder)this.weighting.getFlagEncoder()));
        EdgeIterator iter = explorer.setBaseNode(edge.getAdjNode());
        while (iter.next()) {
            if (iter.getAdjNode() == edge.getBaseNode()) continue;
            return this.traverseToClosestRealAdj((EdgeIteratorState)iter);
        }
        throw new IllegalStateException("Cannot find adjacent edge " + edge);
    }

    private String getSnappedCandidates(Collection<State> candidates) {
        String str = "";
        for (State gpxe : candidates) {
            if (!str.isEmpty()) {
                str = str + ", ";
            }
            str = str + "distance: " + gpxe.getSnap().getQueryDistance() + " to " + gpxe.getSnap().getSnappedPoint();
        }
        return "[" + str + "]";
    }

    private static class MapMatchedPath
    extends Path {
        MapMatchedPath(Graph graph, Weighting weighting, List<EdgeIteratorState> edges) {
            super(graph);
            int prevEdge = -1;
            for (EdgeIteratorState edge : edges) {
                this.addDistance(edge.getDistance());
                this.addTime(GHUtility.calcMillisWithTurnMillis((Weighting)weighting, (EdgeIteratorState)edge, (boolean)false, (int)prevEdge));
                this.addEdge(edge.getEdge());
                prevEdge = edge.getEdge();
            }
            if (edges.isEmpty()) {
                this.setFound(false);
            } else {
                this.setFromNode(edges.get(0).getBaseNode());
                this.setFound(true);
            }
        }
    }
}

