/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs;

import com.carrotsearch.hppc.IntArrayList;
import com.conveyal.gtfs.model.StopTime;
import java.util.ArrayList;
import java.util.List;

public class TripPatternKey {
    public String routeId;
    public List<String> stops = new ArrayList<String>();
    public IntArrayList pickupTypes = new IntArrayList();
    public IntArrayList dropoffTypes = new IntArrayList();

    public TripPatternKey(String routeId) {
        this.routeId = routeId;
    }

    public void addStopTime(StopTime st) {
        this.stops.add(st.stop_id);
        this.pickupTypes.add(st.pickup_type);
        this.dropoffTypes.add(st.drop_off_type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TripPatternKey that = (TripPatternKey)o;
        if (this.dropoffTypes != null ? !this.dropoffTypes.equals(that.dropoffTypes) : that.dropoffTypes != null) {
            return false;
        }
        if (this.pickupTypes != null ? !this.pickupTypes.equals(that.pickupTypes) : that.pickupTypes != null) {
            return false;
        }
        if (this.routeId != null ? !this.routeId.equals(that.routeId) : that.routeId != null) {
            return false;
        }
        return !(this.stops != null ? !this.stops.equals(that.stops) : that.stops != null);
    }

    public int hashCode() {
        int result = this.routeId != null ? this.routeId.hashCode() : 0;
        result = 31 * result + (this.stops != null ? this.stops.hashCode() : 0);
        result = 31 * result + (this.pickupTypes != null ? this.pickupTypes.hashCode() : 0);
        result = 31 * result + (this.dropoffTypes != null ? this.dropoffTypes.hashCode() : 0);
        return result;
    }
}

