/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

public class Agency
extends Entity {
    private static final long serialVersionUID = -2825890165823575940L;
    public String agency_id;
    public String agency_name;
    public URL agency_url;
    public String agency_timezone;
    public String agency_lang;
    public String agency_phone;
    public URL agency_fare_url;
    public URL agency_branding_url;
    public String feed_id;

    public static class Writer
    extends Entity.Writer<Agency> {
        public Writer(GTFSFeed feed) {
            super(feed, "agency");
        }

        @Override
        public void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"agency_id", "agency_name", "agency_url", "agency_lang", "agency_phone", "agency_timezone", "agency_fare_url", "agency_branding_url"});
        }

        @Override
        public void writeOneRow(Agency a) throws IOException {
            this.writeStringField(a.agency_id);
            this.writeStringField(a.agency_name);
            this.writeUrlField(a.agency_url);
            this.writeStringField(a.agency_lang);
            this.writeStringField(a.agency_phone);
            this.writeStringField(a.agency_timezone);
            this.writeUrlField(a.agency_fare_url);
            this.writeUrlField(a.agency_branding_url);
            this.endRecord();
        }

        @Override
        public Iterator<Agency> iterator() {
            return this.feed.agency.values().iterator();
        }
    }

    public static class Loader
    extends Entity.Loader<Agency> {
        public Loader(GTFSFeed feed) {
            super(feed, "agency");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Agency a = new Agency();
            a.sourceFileLine = this.row + 1L;
            a.agency_id = this.getStringField("agency_id", false);
            a.agency_name = this.getStringField("agency_name", true);
            a.agency_url = this.getUrlField("agency_url", true);
            a.agency_lang = this.getStringField("agency_lang", false);
            a.agency_phone = this.getStringField("agency_phone", false);
            a.agency_timezone = this.getStringField("agency_timezone", true);
            a.agency_fare_url = this.getUrlField("agency_fare_url", false);
            a.agency_branding_url = this.getUrlField("agency_branding_url", false);
            a.feed = this.feed;
            a.feed_id = this.feed.feedId;
            if (a.agency_id == null) {
                a.agency_id = "NONE";
            }
            this.feed.agency.put(a.agency_id, a);
        }
    }
}

