/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DuplicateKeyError;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Service;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.Map;

public class CalendarDate
extends Entity
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 6936614582249119431L;
    public String service_id;
    public LocalDate date;
    public int exception_type;

    public CalendarDate clone() {
        try {
            return (CalendarDate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Writer
    extends Entity.Writer<CalendarDate> {
        public Writer(GTFSFeed feed) {
            super(feed, "calendar_dates");
        }

        @Override
        protected void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"service_id", "date", "exception_type"});
        }

        @Override
        protected void writeOneRow(CalendarDate d) throws IOException {
            this.writeStringField(d.service_id);
            this.writeDateField(d.date);
            this.writeIntField(d.exception_type);
            this.endRecord();
        }

        @Override
        protected Iterator<CalendarDate> iterator() {
            Iterator<Service> serviceIterator = this.feed.services.values().iterator();
            return Iterators.concat(Iterators.transform(serviceIterator, new Function<Service, Iterator<CalendarDate>>(){

                @Override
                public Iterator<CalendarDate> apply(Service service) {
                    return service.calendar_dates.values().iterator();
                }
            }));
        }
    }

    public static class Loader
    extends Entity.Loader<CalendarDate> {
        private final Map<String, Service> services;

        public Loader(GTFSFeed feed, Map<String, Service> services) {
            super(feed, "calendar_dates");
            this.services = services;
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            String service_id = this.getStringField("service_id", true);
            Service service = this.services.computeIfAbsent(service_id, Service::new);
            LocalDate date = this.getDateField("date", true);
            if (service.calendar_dates.containsKey(date)) {
                this.feed.errors.add(new DuplicateKeyError(this.tableName, this.row, "(service_id, date)"));
            } else {
                CalendarDate cd = new CalendarDate();
                cd.sourceFileLine = this.row + 1L;
                cd.service_id = service_id;
                cd.date = date;
                cd.exception_type = this.getIntField("exception_type", true, 1, 2);
                cd.feed = this.feed;
                service.calendar_dates.put(date, cd);
            }
        }
    }
}

