/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.error.DuplicateKeyError;
import com.conveyal.gtfs.model.Entity;
import com.conveyal.gtfs.model.Fare;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class FareAttribute
extends Entity {
    private static final long serialVersionUID = 2157859372072056891L;
    public String fare_id;
    public double price;
    public String currency_type;
    public int payment_method;
    public int transfers;
    public int transfer_duration;
    public String feed_id;

    public static class Writer
    extends Entity.Writer<FareAttribute> {
        public Writer(GTFSFeed feed) {
            super(feed, "fare_attributes");
        }

        @Override
        public void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"fare_id", "price", "currency_type", "payment_method", "transfers", "transfer_duration"});
        }

        @Override
        public void writeOneRow(FareAttribute fa) throws IOException {
            this.writeStringField(fa.fare_id);
            this.writeDoubleField(fa.price);
            this.writeStringField(fa.currency_type);
            this.writeIntField(fa.payment_method);
            this.writeIntField(fa.transfers);
            this.writeIntField(fa.transfer_duration);
            this.endRecord();
        }

        @Override
        public Iterator<FareAttribute> iterator() {
            return this.feed.fares.values().stream().map(f -> f.fare_attribute).iterator();
        }
    }

    public static class Loader
    extends Entity.Loader<FareAttribute> {
        private final Map<String, Fare> fares;

        public Loader(GTFSFeed feed, Map<String, Fare> fares) {
            super(feed, "fare_attributes");
            this.fares = fares;
        }

        @Override
        protected boolean isRequired() {
            return false;
        }

        @Override
        public void loadOneRow() throws IOException {
            String fareId = this.getStringField("fare_id", true);
            Fare fare = this.fares.computeIfAbsent(fareId, Fare::new);
            if (fare.fare_attribute != null) {
                this.feed.errors.add(new DuplicateKeyError(this.tableName, this.row, "fare_id"));
            } else {
                FareAttribute fa = new FareAttribute();
                fa.sourceFileLine = this.row + 1L;
                fa.fare_id = fareId;
                fa.price = this.getDoubleField("price", true, 0.0, 2.147483647E9);
                fa.currency_type = this.getStringField("currency_type", true);
                fa.payment_method = this.getIntField("payment_method", true, 0, 1);
                fa.transfers = this.getIntField("transfers", false, 0, 10);
                fa.transfer_duration = this.getIntField("transfer_duration", false, 0, 86400);
                fa.feed = this.feed;
                fa.feed_id = this.feed.feedId;
                fare.fare_attribute = fa;
            }
        }
    }
}

