/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Agency;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

public class Route
extends Entity {
    private static final long serialVersionUID = -819444896818029068L;
    public static final int TRAM = 0;
    public static final int SUBWAY = 1;
    public static final int RAIL = 2;
    public static final int BUS = 3;
    public static final int FERRY = 4;
    public static final int CABLE_CAR = 4;
    public static final int GONDOLA = 4;
    public static final int FUNICULAR = 5;
    public String route_id;
    public String agency_id;
    public String route_short_name;
    public String route_long_name;
    public String route_desc;
    public int route_type;
    public URL route_url;
    public String route_color;
    public String route_text_color;
    public URL route_branding_url;
    public String feed_id;

    public static class Writer
    extends Entity.Writer<Route> {
        public Writer(GTFSFeed feed) {
            super(feed, "routes");
        }

        @Override
        public void writeHeaders() throws IOException {
            this.writeStringField("agency_id");
            this.writeStringField("route_id");
            this.writeStringField("route_short_name");
            this.writeStringField("route_long_name");
            this.writeStringField("route_desc");
            this.writeStringField("route_type");
            this.writeStringField("route_url");
            this.writeStringField("route_color");
            this.writeStringField("route_text_color");
            this.writeStringField("route_branding_url");
            this.endRecord();
        }

        @Override
        public void writeOneRow(Route r) throws IOException {
            this.writeStringField(r.agency_id);
            this.writeStringField(r.route_id);
            this.writeStringField(r.route_short_name);
            this.writeStringField(r.route_long_name);
            this.writeStringField(r.route_desc);
            this.writeIntField(r.route_type);
            this.writeUrlField(r.route_url);
            this.writeStringField(r.route_color);
            this.writeStringField(r.route_text_color);
            this.writeUrlField(r.route_branding_url);
            this.endRecord();
        }

        @Override
        public Iterator<Route> iterator() {
            return this.feed.routes.values().iterator();
        }
    }

    public static class Loader
    extends Entity.Loader<Route> {
        public Loader(GTFSFeed feed) {
            super(feed, "routes");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Route r = new Route();
            r.sourceFileLine = this.row + 1L;
            r.route_id = this.getStringField("route_id", true);
            Agency agency = this.getRefField("agency_id", false, this.feed.agency);
            if (agency == null && this.feed.agency.size() == 1) {
                agency = this.feed.agency.values().iterator().next();
            }
            if (agency != null) {
                r.agency_id = agency.agency_id;
            }
            r.route_short_name = this.getStringField("route_short_name", false);
            r.route_long_name = this.getStringField("route_long_name", false);
            r.route_desc = this.getStringField("route_desc", false);
            r.route_type = this.getIntField("route_type", true, 0, 7);
            r.route_url = this.getUrlField("route_url", false);
            r.route_color = this.getStringField("route_color", false);
            r.route_text_color = this.getStringField("route_text_color", false);
            r.route_branding_url = this.getUrlField("route_branding_url", false);
            r.feed = this.feed;
            r.feed_id = this.feed.feedId;
            this.feed.routes.put(r.route_id, r);
        }
    }
}

