/*
 * Decompiled with CFR 0.152.
 */
package com.conveyal.gtfs.model;

import com.conveyal.gtfs.GTFSFeed;
import com.conveyal.gtfs.model.Entity;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;

public class Stop
extends Entity {
    private static final long serialVersionUID = 464065335273514677L;
    public String stop_id;
    public String stop_code;
    public String stop_name;
    public String stop_desc;
    public double stop_lat;
    public double stop_lon;
    public String zone_id;
    public URL stop_url;
    public int location_type;
    public String parent_station;
    public String stop_timezone;
    public String wheelchair_boarding;
    public String feed_id;

    public static class Writer
    extends Entity.Writer<Stop> {
        public Writer(GTFSFeed feed) {
            super(feed, "stops");
        }

        @Override
        public void writeHeaders() throws IOException {
            this.writer.writeRecord(new String[]{"stop_id", "stop_code", "stop_name", "stop_desc", "stop_lat", "stop_lon", "zone_id", "stop_url", "location_type", "parent_station", "stop_timezone", "wheelchair_boarding"});
        }

        @Override
        public void writeOneRow(Stop s) throws IOException {
            this.writeStringField(s.stop_id);
            this.writeStringField(s.stop_code);
            this.writeStringField(s.stop_name);
            this.writeStringField(s.stop_desc);
            this.writeDoubleField(s.stop_lat);
            this.writeDoubleField(s.stop_lon);
            this.writeStringField(s.zone_id);
            this.writeUrlField(s.stop_url);
            this.writeIntField(s.location_type);
            this.writeStringField(s.parent_station);
            this.writeStringField(s.stop_timezone);
            this.writeStringField(s.wheelchair_boarding);
            this.endRecord();
        }

        @Override
        public Iterator<Stop> iterator() {
            return this.feed.stops.values().iterator();
        }
    }

    public static class Loader
    extends Entity.Loader<Stop> {
        public Loader(GTFSFeed feed) {
            super(feed, "stops");
        }

        @Override
        protected boolean isRequired() {
            return true;
        }

        @Override
        public void loadOneRow() throws IOException {
            Stop s = new Stop();
            s.sourceFileLine = this.row + 1L;
            s.stop_id = this.getStringField("stop_id", true);
            s.stop_code = this.getStringField("stop_code", false);
            s.stop_name = this.getStringField("stop_name", true);
            s.stop_desc = this.getStringField("stop_desc", false);
            s.stop_lat = this.getDoubleField("stop_lat", true, -90.0, 90.0);
            s.stop_lon = this.getDoubleField("stop_lon", true, -180.0, 180.0);
            s.zone_id = this.getStringField("zone_id", false);
            s.stop_url = this.getUrlField("stop_url", false);
            s.location_type = this.getIntField("location_type", false, 0, 1);
            s.parent_station = this.getStringField("parent_station", false);
            s.stop_timezone = this.getStringField("stop_timezone", false);
            s.wheelchair_boarding = this.getStringField("wheelchair_boarding", false);
            s.feed = this.feed;
            s.feed_id = this.feed.feedId;
            this.feed.stops.put(s.stop_id, s);
        }
    }
}

