/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.gtfs.dropwizard;

import com.graphhopper.gtfs.dropwizard.RealtimeBundleConfiguration;
import com.graphhopper.gtfs.dropwizard.RealtimeFeedLoadingCache;
import com.graphhopper.reader.gtfs.RealtimeFeed;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.client.HttpClientBuilder;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import javax.inject.Singleton;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.glassfish.hk2.utilities.binding.AbstractBinder;

public class RealtimeBundle
implements ConfiguredBundle<RealtimeBundleConfiguration> {
    @Override
    public void initialize(Bootstrap<?> bootstrap) {
    }

    @Override
    public void run(final RealtimeBundleConfiguration configuration, Environment environment) {
        final CloseableHttpClient httpClient = new HttpClientBuilder(environment).using(configuration.gtfsrealtime().getHttpClientConfiguration()).build("gtfs-realtime-feed-loader");
        environment.jersey().register(new AbstractBinder(){

            @Override
            protected void configure() {
                this.bind(httpClient).to(HttpClient.class);
                this.bind(configuration).to(RealtimeBundleConfiguration.class);
                this.bindFactory(RealtimeFeedLoadingCache.class, Singleton.class).to(RealtimeFeed.class);
            }
        });
    }
}

