/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.PathWrapper;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Locale;

public class WebHelper {
    public static String encodeURL(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static PointList decodePolyline(String encoded, int initCap, boolean is3D) {
        PointList poly = new PointList(initCap, is3D);
        int index = 0;
        int len = encoded.length();
        int lat = 0;
        int lng = 0;
        int ele = 0;
        while (index < len) {
            int b;
            int shift = 0;
            int result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLatitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lat += deltaLatitude;
            shift = 0;
            result = 0;
            do {
                b = encoded.charAt(index++) - 63;
                result |= (b & 0x1F) << shift;
                shift += 5;
            } while (b >= 32);
            int deltaLongitude = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
            lng += deltaLongitude;
            if (is3D) {
                shift = 0;
                result = 0;
                do {
                    b = encoded.charAt(index++) - 63;
                    result |= (b & 0x1F) << shift;
                    shift += 5;
                } while (b >= 32);
                int deltaElevation = (result & 1) != 0 ? ~(result >> 1) : result >> 1;
                poly.add((double)lat / 100000.0, (double)lng / 100000.0, (double)(ele += deltaElevation) / 100.0);
                continue;
            }
            poly.add((double)lat / 100000.0, (double)lng / 100000.0);
        }
        return poly;
    }

    public static String encodePolyline(PointList poly) {
        if (poly.isEmpty()) {
            return "";
        }
        return WebHelper.encodePolyline(poly, poly.is3D());
    }

    public static String encodePolyline(PointList poly, boolean includeElevation) {
        return WebHelper.encodePolyline(poly, includeElevation, 100000.0);
    }

    public static String encodePolyline(PointList poly, boolean includeElevation, double precision) {
        StringBuilder sb = new StringBuilder();
        int size = poly.getSize();
        int prevLat = 0;
        int prevLon = 0;
        int prevEle = 0;
        for (int i = 0; i < size; ++i) {
            int num = (int)Math.floor(poly.getLatitude(i) * precision);
            WebHelper.encodeNumber(sb, num - prevLat);
            prevLat = num;
            num = (int)Math.floor(poly.getLongitude(i) * precision);
            WebHelper.encodeNumber(sb, num - prevLon);
            prevLon = num;
            if (!includeElevation) continue;
            num = (int)Math.floor(poly.getElevation(i) * 100.0);
            WebHelper.encodeNumber(sb, num - prevEle);
            prevEle = num;
        }
        return sb.toString();
    }

    private static void encodeNumber(StringBuilder sb, int num) {
        if ((num <<= 1) < 0) {
            num ^= 0xFFFFFFFF;
        }
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            sb.append((char)nextValue);
            num >>= 5;
        }
        sb.append((char)(num += 63));
    }

    public static ObjectNode jsonObject(GHResponse ghRsp, boolean enableInstructions, boolean calcPoints, boolean enableElevation, boolean pointsEncoded, float took) {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.putPOJO("hints", ghRsp.getHints().toMap());
        ObjectNode info = json.putObject("info");
        info.putArray("copyrights").add("GraphHopper").add("OpenStreetMap contributors");
        info.put("took", Math.round(took * 1000.0f));
        ArrayNode jsonPathList = json.putArray("paths");
        for (PathWrapper ar : ghRsp.getAll()) {
            ObjectNode jsonPath = jsonPathList.addObject();
            jsonPath.put("distance", Helper.round(ar.getDistance(), 3));
            jsonPath.put("weight", Helper.round6(ar.getRouteWeight()));
            jsonPath.put("time", ar.getTime());
            jsonPath.put("transfers", ar.getNumChanges());
            if (!ar.getDescription().isEmpty()) {
                jsonPath.putPOJO("description", ar.getDescription());
            }
            if (calcPoints) {
                jsonPath.put("points_encoded", pointsEncoded);
                if (ar.getPoints().getSize() >= 2) {
                    jsonPath.putPOJO("bbox", ar.calcBBox2D());
                }
                jsonPath.putPOJO("points", pointsEncoded ? WebHelper.encodePolyline(ar.getPoints(), enableElevation) : ar.getPoints().toLineString(enableElevation));
                if (enableInstructions) {
                    jsonPath.putPOJO("instructions", ar.getInstructions());
                }
                jsonPath.putPOJO("legs", ar.getLegs());
                jsonPath.putPOJO("details", ar.getPathDetails());
                jsonPath.put("ascend", ar.getAscend());
                jsonPath.put("descend", ar.getDescend());
            }
            jsonPath.putPOJO("snapped_waypoints", pointsEncoded ? WebHelper.encodePolyline(ar.getWaypoints(), enableElevation) : ar.getWaypoints().toLineString(enableElevation));
            if (ar.getFare() == null) continue;
            jsonPath.put("fare", NumberFormat.getCurrencyInstance(Locale.ROOT).format(ar.getFare()));
        }
        return json;
    }
}

