/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.http.api;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.util.exceptions.GHException;
import java.util.List;

public class JsonErrorEntity {
    private final List<Throwable> errors;

    public JsonErrorEntity(List<Throwable> t) {
        this.errors = t;
    }

    @JsonValue
    ObjectNode jsonErrorResponse() {
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("message", this.getMessage(this.errors.get(0)));
        ArrayNode errorHintList = json.putArray("hints");
        for (Throwable t : this.errors) {
            ObjectNode error = errorHintList.addObject();
            error.put("message", this.getMessage(t));
            error.put("details", t.getClass().getName());
            if (!(t instanceof GHException)) continue;
            ((GHException)((Object)t)).getDetails().forEach(error::putPOJO);
        }
        return json;
    }

    private String getMessage(Throwable t) {
        if (t.getMessage() == null) {
            return t.getClass().getSimpleName();
        }
        return t.getMessage();
    }
}

