/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.isochrone.algorithm;

import com.graphhopper.isochrone.algorithm.ContourBuilder;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.triangulate.ConformingDelaunayTriangulator;
import org.locationtech.jts.triangulate.ConstraintVertex;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

public class DelaunayTriangulationIsolineBuilder {
    public List<Coordinate[]> calcList(List<List<Coordinate>> pointLists, int maxIsolines) {
        if (maxIsolines > pointLists.size()) {
            throw new IllegalStateException("maxIsolines can only be smaller or equals to pointsList");
        }
        ArrayList<ConstraintVertex> sites = new ArrayList<ConstraintVertex>();
        for (int i = 0; i < pointLists.size(); ++i) {
            List<Coordinate> level = pointLists.get(i);
            for (Coordinate coord : level) {
                ConstraintVertex site = new ConstraintVertex(coord);
                site.setZ(i);
                sites.add(site);
            }
        }
        ConformingDelaunayTriangulator conformingDelaunayTriangulator = new ConformingDelaunayTriangulator(sites, 0.0);
        conformingDelaunayTriangulator.setConstraints(new ArrayList(), new ArrayList());
        conformingDelaunayTriangulator.formInitialDelaunay();
        QuadEdgeSubdivision tin = conformingDelaunayTriangulator.getSubdivision();
        for (Vertex vertex : tin.getVertices(true)) {
            if (!tin.isFrameVertex(vertex)) continue;
            vertex.setZ(Double.MAX_VALUE);
        }
        ArrayList<Coordinate[]> polygonShells = new ArrayList<Coordinate[]>();
        ContourBuilder contourBuilder = new ContourBuilder(tin);
        for (int i = 0; i < maxIsolines; ++i) {
            MultiPolygon multiPolygon = contourBuilder.computeIsoline((double)i + 0.5);
            int maxPoints = 0;
            Polygon maxPolygon = null;
            for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                if (polygon.getNumPoints() <= maxPoints) continue;
                maxPoints = polygon.getNumPoints();
                maxPolygon = polygon;
            }
            if (maxPolygon == null) {
                throw new IllegalStateException("no maximum polygon was found?");
            }
            polygonShells.add(maxPolygon.getExteriorRing().getCoordinates());
        }
        return polygonShells;
    }
}

