/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching;

import com.graphhopper.matching.Observation;
import com.graphhopper.routing.VirtualEdgeIteratorState;
import com.graphhopper.storage.index.QueryResult;
import com.graphhopper.util.EdgeIteratorState;

public class State {
    private final Observation entry;
    private final QueryResult queryResult;
    private final boolean isDirected;
    private final EdgeIteratorState incomingVirtualEdge;
    private final EdgeIteratorState outgoingVirtualEdge;

    public State(Observation entry, QueryResult queryResult) {
        this.entry = entry;
        this.queryResult = queryResult;
        this.isDirected = false;
        this.incomingVirtualEdge = null;
        this.outgoingVirtualEdge = null;
    }

    public State(Observation entry, QueryResult queryResult, VirtualEdgeIteratorState incomingVirtualEdge, VirtualEdgeIteratorState outgoingVirtualEdge) {
        this.entry = entry;
        this.queryResult = queryResult;
        this.isDirected = true;
        this.incomingVirtualEdge = incomingVirtualEdge;
        this.outgoingVirtualEdge = outgoingVirtualEdge;
    }

    public Observation getEntry() {
        return this.entry;
    }

    public QueryResult getQueryResult() {
        return this.queryResult;
    }

    public boolean isOnDirectedEdge() {
        return this.isDirected;
    }

    public EdgeIteratorState getIncomingVirtualEdge() {
        if (!this.isDirected) {
            throw new IllegalStateException("This method may only be called for directed GPXExtensions");
        }
        return this.incomingVirtualEdge;
    }

    public EdgeIteratorState getOutgoingVirtualEdge() {
        if (!this.isDirected) {
            throw new IllegalStateException("This method may only be called for directed GPXExtensions");
        }
        return this.outgoingVirtualEdge;
    }

    public String toString() {
        return "State{closest node=" + this.queryResult.getClosestNode() + " at " + this.queryResult.getSnappedPoint().getLat() + "," + this.queryResult.getSnappedPoint().getLon() + ", incomingEdge=" + this.incomingVirtualEdge + ", outgoingEdge=" + this.outgoingVirtualEdge + '}';
    }
}

