/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching.cli;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.reader.osm.GraphHopperOSM;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.GraphHopperStorage;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.CmdArgs;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.Helper;
import com.graphhopper.util.MiniPerfTest;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.GHPoint;
import io.dropwizard.cli.Command;
import io.dropwizard.setup.Bootstrap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementCommand
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementCommand.class);
    private final Map<String, String> properties = new TreeMap<String, String>();
    private BBox bbox;
    private DistanceCalcEarth distCalc = new DistanceCalcEarth();
    private long seed;
    private int count;

    public MeasurementCommand() {
        super("measurement", "runs performance tests on the imported graph");
    }

    @Override
    public void configure(Subparser subparser) {
        subparser.addArgument("outfile").type(File.class).required(true).help("output file name for the measurement results");
        subparser.addArgument("--seed").type(Long.class).required(false).setDefault((Object)123L).help("random seed");
        subparser.addArgument("--count").type(Integer.class).required(false).setDefault((Object)100).help("number of operations to perform");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Bootstrap bootstrap, Namespace args) {
        CmdArgs graphHopperConfiguration = new CmdArgs();
        graphHopperConfiguration.put("graph.location", "graph-cache");
        this.seed = args.getLong("seed");
        this.count = args.getInt("count");
        GraphHopperOSM graphHopper = new GraphHopperOSM();
        graphHopper.init(graphHopperConfiguration).forDesktop();
        graphHopper.getCHFactoryDecorator().setEnabled(false);
        graphHopper.getCHFactoryDecorator().setDisablingAllowed(true);
        graphHopper.importOrLoad();
        GraphHopperStorage graph = graphHopper.getGraphHopperStorage();
        this.bbox = graph.getBounds();
        LocationIndexTree locationIndex = (LocationIndexTree)graphHopper.getLocationIndex();
        AlgorithmOptions algoOpts = AlgorithmOptions.start().maxVisitedNodes(Integer.MAX_VALUE).build();
        MapMatching mapMatching = new MapMatching(graphHopper, algoOpts);
        StopWatch sw = new StopWatch().start();
        try {
            this.printLocationIndexMatchQuery(locationIndex);
            this.printTimeOfMapMatchQuery(graphHopper, mapMatching);
            System.gc();
        }
        catch (Exception ex) {
            logger.error("Problem while measuring", ex);
            this.properties.put("error", "" + ex.toString());
        }
        finally {
            this.properties.put("measurement.count", "" + this.count);
            this.properties.put("measurement.seed", "" + this.seed);
            this.properties.put("measurement.time", "" + sw.stop().getMillis());
            System.gc();
            this.properties.put("measurement.totalMB", "" + Helper.getTotalMB());
            this.properties.put("measurement.usedMB", "" + Helper.getUsedMB());
            try {
                FileWriter fileWriter = new FileWriter((File)args.get("outfile"));
                for (Map.Entry<String, String> e : this.properties.entrySet()) {
                    fileWriter.append(e.getKey());
                    fileWriter.append("=");
                    fileWriter.append(e.getValue());
                    fileWriter.append("\n");
                }
                fileWriter.flush();
            }
            catch (IOException ex) {
                logger.error("Problem while writing measurements", ex);
            }
        }
    }

    private void printLocationIndexMatchQuery(final LocationIndexTree idx) {
        final double latDelta = this.bbox.maxLat - this.bbox.minLat;
        final double lonDelta = this.bbox.maxLon - this.bbox.minLon;
        final Random rand = new Random(this.seed);
        MiniPerfTest miniPerf = new MiniPerfTest(){

            @Override
            public int doCalc(boolean warmup, int run) {
                double lat = rand.nextDouble() * latDelta + ((MeasurementCommand)MeasurementCommand.this).bbox.minLat;
                double lon = rand.nextDouble() * lonDelta + ((MeasurementCommand)MeasurementCommand.this).bbox.minLon;
                return idx.findNClosest(lat, lon, EdgeFilter.ALL_EDGES, rand.nextDouble() * 500.0).size();
            }
        }.setIterations(this.count).start();
        this.print("location_index_match", miniPerf);
    }

    private void printTimeOfMapMatchQuery(final GraphHopper hopper, final MapMatching mapMatching) {
        final double latDelta = this.bbox.maxLat - this.bbox.minLat;
        final double lonDelta = this.bbox.maxLon - this.bbox.minLon;
        final Random rand = new Random(this.seed);
        MiniPerfTest miniPerf = new MiniPerfTest(){

            @Override
            public int doCalc(boolean warmup, int run) {
                ArrayList<Observation> mock;
                while (true) {
                    double lon1;
                    double lat1;
                    double lon0;
                    double lat0;
                    GHResponse r;
                    if ((r = hopper.route(new GHRequest(lat0 = ((MeasurementCommand)MeasurementCommand.this).bbox.minLat + rand.nextDouble() * latDelta, lon0 = ((MeasurementCommand)MeasurementCommand.this).bbox.minLon + rand.nextDouble() * lonDelta, lat1 = ((MeasurementCommand)MeasurementCommand.this).bbox.minLat + rand.nextDouble() * latDelta, lon1 = ((MeasurementCommand)MeasurementCommand.this).bbox.minLon + rand.nextDouble() * lonDelta))).hasErrors()) {
                        continue;
                    }
                    double sampleProportion = rand.nextDouble();
                    GHPoint prev = null;
                    mock = new ArrayList<Observation>();
                    PointList points = r.getBest().getPoints();
                    for (GHPoint p : points) {
                        if (null != prev && rand.nextDouble() < sampleProportion) {
                            GHPoint randomised = MeasurementCommand.this.distCalc.projectCoordinate(p.lat, p.lon, 20.0 * rand.nextDouble(), 360.0 * rand.nextDouble());
                            mock.add(new Observation(randomised));
                        }
                        prev = p;
                    }
                    if (mock.size() > 2) break;
                }
                MatchResult match = mapMatching.doWork(mock);
                return match.getEdgeMatches().size();
            }
        }.setIterations(this.count).start();
        this.print("map_match", miniPerf);
    }

    private void print(String prefix, MiniPerfTest perf) {
        logger.info(prefix + ": " + perf.getReport());
        this.properties.put(prefix + ".sum", "" + Double.valueOf(perf.getSum()));
        this.properties.put(prefix + ".min", "" + Double.valueOf(perf.getMin()));
        this.properties.put(prefix + ".mean", "" + Double.valueOf(perf.getMean()));
        this.properties.put(prefix + ".max", "" + Double.valueOf(perf.getMax()));
    }
}

