/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching.gpx;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.gpx.Trkpt;
import com.graphhopper.matching.gpx.Trkseg;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Trk {
    @JacksonXmlElementWrapper(useWrapping=false)
    public List<Trkseg> trkseg;
    public String name;

    public List<Observation> getEntries() {
        ArrayList<Observation> gpxEntries = new ArrayList<Observation>();
        for (Trkseg t : this.trkseg) {
            for (Trkpt trkpt : t.trkpt) {
                gpxEntries.add(new Observation(new GHPoint3D(trkpt.lat, trkpt.lon, trkpt.ele)));
            }
        }
        return gpxEntries;
    }

    public Optional<Date> getStartTime() {
        return this.trkseg.stream().flatMap(trkseg -> trkseg.trkpt.stream()).findFirst().flatMap(trkpt -> Optional.ofNullable(trkpt.time));
    }
}

