/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.matching.http;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.PathWrapper;
import com.graphhopper.http.WebHelper;
import com.graphhopper.matching.EdgeMatch;
import com.graphhopper.matching.MapMatching;
import com.graphhopper.matching.MatchResult;
import com.graphhopper.matching.Observation;
import com.graphhopper.matching.State;
import com.graphhopper.matching.gpx.Gpx;
import com.graphhopper.routing.AlgorithmOptions;
import com.graphhopper.routing.util.HintsMap;
import com.graphhopper.util.Constants;
import com.graphhopper.util.DouglasPeucker;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PathMerger;
import com.graphhopper.util.PointList;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.gpx.GpxFromInstructions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="match")
public class MapMatchingResource {
    private static final Logger logger = LoggerFactory.getLogger(MapMatchingResource.class);
    private final GraphHopper graphHopper;
    private final TranslationMap trMap;

    @Inject
    public MapMatchingResource(GraphHopper graphHopper, TranslationMap trMap) {
        this.graphHopper = graphHopper;
        this.trMap = trMap;
    }

    @POST
    @Consumes(value={"application/xml", "application/gpx+xml"})
    @Produces(value={"application/json", "application/xml", "application/gpx+xml"})
    public Response match(Gpx gpx, @Context HttpServletRequest request, @QueryParam(value="way_point_max_distance") @DefaultValue(value="1") double minPathPrecision, @QueryParam(value="type") @DefaultValue(value="json") String outType, @QueryParam(value="instructions") @DefaultValue(value="true") boolean instructions, @QueryParam(value="calc_points") @DefaultValue(value="true") boolean calcPoints, @QueryParam(value="elevation") @DefaultValue(value="false") boolean enableElevation, @QueryParam(value="points_encoded") @DefaultValue(value="true") boolean pointsEncoded, @QueryParam(value="vehicle") @DefaultValue(value="car") String vehicleStr, @QueryParam(value="locale") @DefaultValue(value="en") String localeStr, @QueryParam(value="details") List<String> pathDetails, @QueryParam(value="gpx.route") @DefaultValue(value="true") boolean withRoute, @QueryParam(value="gpx.track") @DefaultValue(value="true") boolean withTrack, @QueryParam(value="traversal_keys") @DefaultValue(value="false") boolean enableTraversalKeys, @QueryParam(value="max_visited_nodes") @DefaultValue(value="3000") int maxVisitedNodes, @QueryParam(value="gps_accuracy") @DefaultValue(value="40") double gpsAccuracy) {
        boolean writeGPX = "gpx".equalsIgnoreCase(outType);
        if (gpx.trk == null) {
            throw new IllegalArgumentException("No tracks found in GPX document. Are you using waypoints or routes instead?");
        }
        if (gpx.trk.size() > 1) {
            throw new IllegalArgumentException("GPX documents with multiple tracks not supported yet.");
        }
        instructions = writeGPX || instructions;
        StopWatch sw = new StopWatch().start();
        AlgorithmOptions opts = AlgorithmOptions.start().traversalMode(this.graphHopper.getTraversalMode()).maxVisitedNodes(maxVisitedNodes).hints(new HintsMap().put("vehicle", vehicleStr)).build();
        MapMatching matching = new MapMatching(this.graphHopper, opts);
        matching.setMeasurementErrorSigma(gpsAccuracy);
        List<Observation> measurements = gpx.trk.get(0).getEntries();
        MatchResult matchResult = matching.doWork(measurements);
        float took = sw.stop().getSeconds();
        String infoStr = request.getRemoteAddr() + " " + request.getLocale() + " " + request.getHeader("User-Agent");
        String logStr = request.getQueryString() + ", " + infoStr + ", took:" + took + ", entries:" + measurements.size();
        logger.info(logStr);
        if ("extended_json".equals(outType)) {
            return Response.ok(MapMatchingResource.convertToTree(matchResult, enableElevation, pointsEncoded)).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
        }
        Translation tr = this.trMap.getWithFallBack(Helper.getLocale(localeStr));
        DouglasPeucker peucker = new DouglasPeucker().setMaxDistance(minPathPrecision);
        PathMerger pathMerger = new PathMerger().setEnableInstructions(instructions).setPathDetailsBuilders(this.graphHopper.getPathDetailsBuilderFactory(), pathDetails).setDouglasPeucker(peucker).setSimplifyResponse(minPathPrecision > 0.0);
        PathWrapper pathWrapper = new PathWrapper();
        pathMerger.doWork(pathWrapper, Collections.singletonList(matchResult.getMergedPath()), this.graphHopper.getEncodingManager(), tr);
        pathWrapper.getErrors().clear();
        GHResponse rsp = new GHResponse();
        rsp.add(pathWrapper);
        if (writeGPX) {
            long time = gpx.trk.get(0).getStartTime().map(Date::getTime).orElse(System.currentTimeMillis());
            return Response.ok((Object)GpxFromInstructions.createGPX(rsp.getBest().getInstructions(), gpx.trk.get((int)0).name != null ? gpx.trk.get((int)0).name : "", time, enableElevation, withRoute, withTrack, false, Constants.VERSION, tr), "application/gpx+xml").header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
        }
        ObjectNode map = WebHelper.jsonObject(rsp, instructions, calcPoints, enableElevation, pointsEncoded, took);
        HashMap<String, Number> matchStatistics = new HashMap<String, Number>();
        matchStatistics.put("distance", matchResult.getMatchLength());
        matchStatistics.put("time", matchResult.getMatchMillis());
        matchStatistics.put("original_distance", matchResult.getGpxEntriesLength());
        map.putPOJO("map_matching", matchStatistics);
        if (enableTraversalKeys) {
            ArrayList<Integer> traversalKeylist = new ArrayList<Integer>();
            for (EdgeMatch em : matchResult.getEdgeMatches()) {
                EdgeIteratorState edge = em.getEdgeState();
                traversalKeylist.add(GHUtility.createEdgeKey(edge.getBaseNode(), edge.getAdjNode(), edge.getEdge(), false));
            }
            map.putPOJO("traversal_keys", traversalKeylist);
        }
        return Response.ok(map).header("X-GH-Took", "" + Math.round(took * 1000.0f)).build();
    }

    static JsonNode convertToTree(MatchResult result, boolean elevation, boolean pointsEncoded) {
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode diary = root.putObject("diary");
        ArrayNode entries = diary.putArray("entries");
        ObjectNode route = entries.addObject();
        ArrayNode links = route.putArray("links");
        for (int emIndex = 0; emIndex < result.getEdgeMatches().size(); ++emIndex) {
            ObjectNode link = links.addObject();
            EdgeMatch edgeMatch = result.getEdgeMatches().get(emIndex);
            PointList pointList = edgeMatch.getEdgeState().fetchWayGeometry(emIndex == 0 ? 3 : 2);
            ObjectNode geometry = link.putObject("geometry");
            if (pointList.size() < 2) {
                geometry.putPOJO("coordinates", pointsEncoded ? WebHelper.encodePolyline(pointList, elevation) : pointList.toLineString(elevation));
                geometry.put("type", "Point");
            } else {
                geometry.putPOJO("coordinates", pointsEncoded ? WebHelper.encodePolyline(pointList, elevation) : pointList.toLineString(elevation));
                geometry.put("type", "LineString");
            }
            link.put("id", edgeMatch.getEdgeState().getEdge());
            ArrayNode wpts = link.putArray("wpts");
            for (State extension : edgeMatch.getStates()) {
                ObjectNode wpt = wpts.addObject();
                wpt.put("x", extension.getQueryResult().getSnappedPoint().lon);
                wpt.put("y", extension.getQueryResult().getSnappedPoint().lat);
            }
        }
        return root;
    }
}

