/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader;

import com.graphhopper.reader.ReaderElement;
import com.graphhopper.util.PointAccess;

public class ReaderNode
extends ReaderElement {
    private final double lat;
    private final double lon;

    public ReaderNode(long id, PointAccess pointAccess, int accessId) {
        super(id, 0);
        this.lat = pointAccess.getLatitude(accessId);
        this.lon = pointAccess.getLongitude(accessId);
        if (pointAccess.is3D()) {
            this.setTag("ele", pointAccess.getElevation(accessId));
        }
    }

    public ReaderNode(long id, double lat, double lon) {
        super(id, 0);
        this.lat = lat;
        this.lon = lon;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getEle() {
        Object ele = this.getTags().get("ele");
        if (ele == null) {
            return Double.NaN;
        }
        return (Double)ele;
    }

    @Override
    public void setTag(String name, Object value) {
        if ("ele".equals(name)) {
            if (value == null) {
                value = null;
            } else if (value instanceof String) {
                String str = (String)value;
                if ((str = str.trim().replaceAll("\\,", ".")).isEmpty()) {
                    value = null;
                } else {
                    try {
                        value = Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        return;
                    }
                }
            } else {
                value = ((Number)value).doubleValue();
            }
        }
        super.setTag(name, value);
    }

    @Override
    public String toString() {
        StringBuilder txt = new StringBuilder();
        txt.append("Node: ");
        txt.append(this.getId());
        txt.append(" lat=");
        txt.append(this.getLat());
        txt.append(" lon=");
        txt.append(this.getLon());
        if (!this.getTags().isEmpty()) {
            txt.append("\n");
            txt.append(this.tagsToString());
        }
        return txt.toString();
    }
}

