/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.util.Downloader;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractElevationProvider
implements ElevationProvider {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    Downloader downloader;
    final File cacheDir;
    String baseUrl;
    Directory dir;
    DAType daType = DAType.MMAP;
    boolean calcMean = false;
    boolean autoRemoveTemporary = true;
    long sleep = 2000L;

    protected AbstractElevationProvider(String cacheDirString) {
        File cacheDir = new File(cacheDirString);
        if (cacheDir.exists() && !cacheDir.isDirectory()) {
            throw new IllegalArgumentException("Cache path has to be a directory");
        }
        try {
            this.cacheDir = cacheDir.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setCalcMean(boolean eleCalcMean) {
        this.calcMean = eleCalcMean;
    }

    void setSleep(long sleep) {
        this.sleep = sleep;
    }

    @Override
    public void setAutoRemoveTemporaryFiles(boolean autoRemoveTemporary) {
        this.autoRemoveTemporary = autoRemoveTemporary;
    }

    public void setDownloader(Downloader downloader) {
        this.downloader = downloader;
    }

    protected File getCacheDir() {
        return this.cacheDir;
    }

    @Override
    public ElevationProvider setBaseURL(String baseUrl) {
        if (baseUrl == null || baseUrl.isEmpty()) {
            throw new IllegalArgumentException("baseUrl cannot be empty");
        }
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public ElevationProvider setDAType(DAType daType) {
        this.daType = daType;
        return this;
    }

    protected Directory getDirectory() {
        if (this.dir != null) {
            return this.dir;
        }
        this.logger.info(this.toString() + " Elevation Provider, from: " + this.baseUrl + ", to: " + this.cacheDir + ", as: " + this.daType + " using calcmean: " + this.calcMean);
        this.dir = new GHDirectory(this.cacheDir.getAbsolutePath(), this.daType);
        return this.dir;
    }

    abstract String getFileName(double var1, double var3);

    abstract String getDownloadURL(double var1, double var3);
}

